// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.transform

import aws.sdk.kotlin.services.securityhub.model.ControlStatus
import aws.sdk.kotlin.services.securityhub.model.UpdateStandardsControlRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateStandardsControlOperationSerializer: HttpSerialize<UpdateStandardsControlRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateStandardsControlRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            val pathSegments = listOf<String>(
                "standards",
                "control",
                "${input.standardsControlArn}".encodeLabel(greedy = true),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateStandardsControlOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateStandardsControlOperationBody(context: ExecutionContext, input: UpdateStandardsControlRequest): ByteArray {
    val serializer = JsonSerializer()
    val CONTROLSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ControlStatus"))
    val DISABLEDREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DisabledReason"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTROLSTATUS_DESCRIPTOR)
        field(DISABLEDREASON_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.controlStatus?.let { field(CONTROLSTATUS_DESCRIPTOR, it.value) }
        input.disabledReason?.let { field(DISABLEDREASON_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
