// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.transform

import aws.sdk.kotlin.services.securityhub.model.AutoEnableStandards
import aws.sdk.kotlin.services.securityhub.model.DescribeOrganizationConfigurationResponse
import aws.sdk.kotlin.services.securityhub.model.SecurityHubException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeOrganizationConfigurationOperationDeserializer: HttpDeserialize<DescribeOrganizationConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeOrganizationConfigurationResponse {
        if (!response.status.isSuccess()) {
            throwDescribeOrganizationConfigurationError(context, response)
        }
        val builder = DescribeOrganizationConfigurationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeOrganizationConfigurationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeOrganizationConfigurationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SecurityHubException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidAccessException" -> InvalidAccessExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SecurityHubException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeOrganizationConfigurationOperationBody(builder: DescribeOrganizationConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTOENABLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("AutoEnable"))
    val AUTOENABLESTANDARDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("AutoEnableStandards"))
    val MEMBERACCOUNTLIMITREACHED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("MemberAccountLimitReached"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTOENABLE_DESCRIPTOR)
        field(AUTOENABLESTANDARDS_DESCRIPTOR)
        field(MEMBERACCOUNTLIMITREACHED_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTOENABLE_DESCRIPTOR.index -> builder.autoEnable = deserializeBoolean()
                AUTOENABLESTANDARDS_DESCRIPTOR.index -> builder.autoEnableStandards = deserializeString().let { AutoEnableStandards.fromValue(it) }
                MEMBERACCOUNTLIMITREACHED_DESCRIPTOR.index -> builder.memberAccountLimitReached = deserializeBoolean()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
