// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.transform

import aws.sdk.kotlin.services.securityhub.model.BatchImportFindingsResponse
import aws.sdk.kotlin.services.securityhub.model.ImportFindingsError
import aws.sdk.kotlin.services.securityhub.model.SecurityHubException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchImportFindingsOperationDeserializer: HttpDeserialize<BatchImportFindingsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchImportFindingsResponse {
        if (!response.status.isSuccess()) {
            throwBatchImportFindingsError(context, response)
        }
        val builder = BatchImportFindingsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchImportFindingsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchImportFindingsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SecurityHubException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidAccessException" -> InvalidAccessExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SecurityHubException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchImportFindingsOperationBody(builder: BatchImportFindingsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FAILEDCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("FailedCount"))
    val FAILEDFINDINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FailedFindings"))
    val SUCCESSCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("SuccessCount"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FAILEDCOUNT_DESCRIPTOR)
        field(FAILEDFINDINGS_DESCRIPTOR)
        field(SUCCESSCOUNT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FAILEDCOUNT_DESCRIPTOR.index -> builder.failedCount = deserializeInt()
                FAILEDFINDINGS_DESCRIPTOR.index -> builder.failedFindings =
                    deserializer.deserializeList(FAILEDFINDINGS_DESCRIPTOR) {
                        val col0 = mutableListOf<ImportFindingsError>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeImportFindingsErrorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SUCCESSCOUNT_DESCRIPTOR.index -> builder.successCount = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
