// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.transform

import aws.sdk.kotlin.services.securityhub.model.BatchDeleteAutomationRulesResponse
import aws.sdk.kotlin.services.securityhub.model.SecurityHubException
import aws.sdk.kotlin.services.securityhub.model.UnprocessedAutomationRule
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchDeleteAutomationRulesOperationDeserializer: HttpDeserialize<BatchDeleteAutomationRulesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchDeleteAutomationRulesResponse {
        if (!response.status.isSuccess()) {
            throwBatchDeleteAutomationRulesError(context, response)
        }
        val builder = BatchDeleteAutomationRulesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchDeleteAutomationRulesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchDeleteAutomationRulesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SecurityHubException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidAccessException" -> InvalidAccessExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SecurityHubException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchDeleteAutomationRulesOperationBody(builder: BatchDeleteAutomationRulesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PROCESSEDAUTOMATIONRULES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ProcessedAutomationRules"))
    val UNPROCESSEDAUTOMATIONRULES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("UnprocessedAutomationRules"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PROCESSEDAUTOMATIONRULES_DESCRIPTOR)
        field(UNPROCESSEDAUTOMATIONRULES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PROCESSEDAUTOMATIONRULES_DESCRIPTOR.index -> builder.processedAutomationRules =
                    deserializer.deserializeList(PROCESSEDAUTOMATIONRULES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                UNPROCESSEDAUTOMATIONRULES_DESCRIPTOR.index -> builder.unprocessedAutomationRules =
                    deserializer.deserializeList(UNPROCESSEDAUTOMATIONRULES_DESCRIPTOR) {
                        val col0 = mutableListOf<UnprocessedAutomationRule>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUnprocessedAutomationRuleDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
