// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * A vendor that generates a vulnerability report.
 */
public class VulnerabilityVendor private constructor(builder: Builder) {
    /**
     * The name of the vendor.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The URL of the vulnerability advisory.
     */
    public val url: kotlin.String? = builder.url
    /**
     * Indicates when the vulnerability advisory was created.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val vendorCreatedAt: kotlin.String? = builder.vendorCreatedAt
    /**
     * The severity that the vendor assigned to the vulnerability.
     */
    public val vendorSeverity: kotlin.String? = builder.vendorSeverity
    /**
     * Indicates when the vulnerability advisory was last updated.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val vendorUpdatedAt: kotlin.String? = builder.vendorUpdatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.VulnerabilityVendor = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VulnerabilityVendor(")
        append("name=$name,")
        append("url=$url,")
        append("vendorCreatedAt=$vendorCreatedAt,")
        append("vendorSeverity=$vendorSeverity,")
        append("vendorUpdatedAt=$vendorUpdatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (url?.hashCode() ?: 0)
        result = 31 * result + (vendorCreatedAt?.hashCode() ?: 0)
        result = 31 * result + (vendorSeverity?.hashCode() ?: 0)
        result = 31 * result + (vendorUpdatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VulnerabilityVendor

        if (name != other.name) return false
        if (url != other.url) return false
        if (vendorCreatedAt != other.vendorCreatedAt) return false
        if (vendorSeverity != other.vendorSeverity) return false
        if (vendorUpdatedAt != other.vendorUpdatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.VulnerabilityVendor = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the vendor.
         */
        public var name: kotlin.String? = null
        /**
         * The URL of the vulnerability advisory.
         */
        public var url: kotlin.String? = null
        /**
         * Indicates when the vulnerability advisory was created.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var vendorCreatedAt: kotlin.String? = null
        /**
         * The severity that the vendor assigned to the vulnerability.
         */
        public var vendorSeverity: kotlin.String? = null
        /**
         * Indicates when the vulnerability advisory was last updated.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var vendorUpdatedAt: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.VulnerabilityVendor) : this() {
            this.name = x.name
            this.url = x.url
            this.vendorCreatedAt = x.vendorCreatedAt
            this.vendorSeverity = x.vendorSeverity
            this.vendorUpdatedAt = x.vendorUpdatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.VulnerabilityVendor = VulnerabilityVendor(this)
    }
}
