// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * A security control in Security Hub describes a security best practice related to a specific resource.
 */
public class SecurityControl private constructor(builder: Builder) {
    /**
     * The description of a security control across standards. This typically summarizes how Security Hub evaluates the control and the conditions under which it produces a failed finding. This parameter doesn't reference a specific standard.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A link to Security Hub documentation that explains how to remediate a failed finding for a security control.
     */
    public val remediationUrl: kotlin.String? = builder.remediationUrl
    /**
     * The Amazon Resource Name (ARN) for a security control across standards, such as `arn:aws:securityhub:eu-central-1:123456789012:security-control/S3.1`. This parameter doesn't mention a specific standard.
     */
    public val securityControlArn: kotlin.String? = builder.securityControlArn
    /**
     * The unique identifier of a security control across standards. Values for this field typically consist of an Amazon Web Service name and a number, such as APIGateway.3.
     */
    public val securityControlId: kotlin.String? = builder.securityControlId
    /**
     * The status of a security control based on the compliance status of its findings. For more information about how control status is determined, see [Determining the overall status of a control from its findings](https://docs.aws.amazon.com/securityhub/latest/userguide/controls-overall-status.html) in the *Security Hub User Guide*.
     */
    public val securityControlStatus: aws.sdk.kotlin.services.securityhub.model.ControlStatus? = builder.securityControlStatus
    /**
     * The severity of a security control. For more information about how Security Hub determines control severity, see [Assigning severity to control findings](https://docs.aws.amazon.com/securityhub/latest/userguide/controls-findings-create-update.html#control-findings-severity) in the *Security Hub User Guide*.
     */
    public val severityRating: aws.sdk.kotlin.services.securityhub.model.SeverityRating? = builder.severityRating
    /**
     * The title of a security control.
     */
    public val title: kotlin.String? = builder.title

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.SecurityControl = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SecurityControl(")
        append("description=$description,")
        append("remediationUrl=$remediationUrl,")
        append("securityControlArn=$securityControlArn,")
        append("securityControlId=$securityControlId,")
        append("securityControlStatus=$securityControlStatus,")
        append("severityRating=$severityRating,")
        append("title=$title")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (remediationUrl?.hashCode() ?: 0)
        result = 31 * result + (securityControlArn?.hashCode() ?: 0)
        result = 31 * result + (securityControlId?.hashCode() ?: 0)
        result = 31 * result + (securityControlStatus?.hashCode() ?: 0)
        result = 31 * result + (severityRating?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SecurityControl

        if (description != other.description) return false
        if (remediationUrl != other.remediationUrl) return false
        if (securityControlArn != other.securityControlArn) return false
        if (securityControlId != other.securityControlId) return false
        if (securityControlStatus != other.securityControlStatus) return false
        if (severityRating != other.severityRating) return false
        if (title != other.title) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.SecurityControl = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The description of a security control across standards. This typically summarizes how Security Hub evaluates the control and the conditions under which it produces a failed finding. This parameter doesn't reference a specific standard.
         */
        public var description: kotlin.String? = null
        /**
         * A link to Security Hub documentation that explains how to remediate a failed finding for a security control.
         */
        public var remediationUrl: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for a security control across standards, such as `arn:aws:securityhub:eu-central-1:123456789012:security-control/S3.1`. This parameter doesn't mention a specific standard.
         */
        public var securityControlArn: kotlin.String? = null
        /**
         * The unique identifier of a security control across standards. Values for this field typically consist of an Amazon Web Service name and a number, such as APIGateway.3.
         */
        public var securityControlId: kotlin.String? = null
        /**
         * The status of a security control based on the compliance status of its findings. For more information about how control status is determined, see [Determining the overall status of a control from its findings](https://docs.aws.amazon.com/securityhub/latest/userguide/controls-overall-status.html) in the *Security Hub User Guide*.
         */
        public var securityControlStatus: aws.sdk.kotlin.services.securityhub.model.ControlStatus? = null
        /**
         * The severity of a security control. For more information about how Security Hub determines control severity, see [Assigning severity to control findings](https://docs.aws.amazon.com/securityhub/latest/userguide/controls-findings-create-update.html#control-findings-severity) in the *Security Hub User Guide*.
         */
        public var severityRating: aws.sdk.kotlin.services.securityhub.model.SeverityRating? = null
        /**
         * The title of a security control.
         */
        public var title: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.SecurityControl) : this() {
            this.description = x.description
            this.remediationUrl = x.remediationUrl
            this.securityControlArn = x.securityControlArn
            this.securityControlId = x.securityControlId
            this.securityControlStatus = x.securityControlStatus
            this.severityRating = x.severityRating
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.SecurityControl = SecurityControl(this)
    }
}
