// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetFindingHistoryRequest private constructor(builder: Builder) {
    /**
     * An ISO 8601-formatted timestamp that indicates the end time of the requested finding history. A correctly formatted example is `2020-05-21T20:16:34.724Z`. The value cannot contain spaces, and date and time should be separated by `T`. For more information, see [RFC 3339 section 5.6, Internet Date/Time Format](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
     *
     * If you provide values for both `StartTime` and `EndTime`, Security Hub returns finding history for the specified time period. If you provide a value for `StartTime` but not for `EndTime`, Security Hub returns finding history from the `StartTime` to the time at which the API is called. If you provide a value for `EndTime` but not for `StartTime`, Security Hub returns finding history from the [CreatedAt](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_AwsSecurityFindingFilters.html#securityhub-Type-AwsSecurityFindingFilters-CreatedAt) timestamp of the finding to the `EndTime`. If you provide neither `StartTime` nor `EndTime`, Security Hub returns finding history from the CreatedAt timestamp of the finding to the time at which the API is called. In all of these scenarios, the response is limited to 100 results, and the maximum time period is limited to 90 days.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * Identifies which finding to get the finding history for.
     */
    public val findingIdentifier: aws.sdk.kotlin.services.securityhub.model.AwsSecurityFindingIdentifier? = builder.findingIdentifier
    /**
     * The maximum number of results to be returned. If you don’t provide it, Security Hub returns up to 100 results of finding history.
     */
    public val maxResults: kotlin.Int = builder.maxResults
    /**
     * A token for pagination purposes. Provide `NULL` as the initial value. In subsequent requests, provide the token included in the response to get up to an additional 100 results of finding history. If you don’t provide `NextToken`, Security Hub returns up to 100 results of finding history for each request.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * An ISO 8601-formatted timestamp that indicates the start time of the requested finding history. A correctly formatted example is `2020-05-21T20:16:34.724Z`. The value cannot contain spaces, and date and time should be separated by `T`. For more information, see [RFC 3339 section 5.6, Internet Date/Time Format](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
     *
     * If you provide values for both `StartTime` and `EndTime`, Security Hub returns finding history for the specified time period. If you provide a value for `StartTime` but not for `EndTime`, Security Hub returns finding history from the `StartTime` to the time at which the API is called. If you provide a value for `EndTime` but not for `StartTime`, Security Hub returns finding history from the [CreatedAt](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_AwsSecurityFindingFilters.html#securityhub-Type-AwsSecurityFindingFilters-CreatedAt) timestamp of the finding to the `EndTime`. If you provide neither `StartTime` nor `EndTime`, Security Hub returns finding history from the CreatedAt timestamp of the finding to the time at which the API is called. In all of these scenarios, the response is limited to 100 results, and the maximum time period is limited to 90 days.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.GetFindingHistoryRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetFindingHistoryRequest(")
        append("endTime=$endTime,")
        append("findingIdentifier=$findingIdentifier,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("startTime=$startTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (findingIdentifier?.hashCode() ?: 0)
        result = 31 * result + (maxResults)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetFindingHistoryRequest

        if (endTime != other.endTime) return false
        if (findingIdentifier != other.findingIdentifier) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.GetFindingHistoryRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An ISO 8601-formatted timestamp that indicates the end time of the requested finding history. A correctly formatted example is `2020-05-21T20:16:34.724Z`. The value cannot contain spaces, and date and time should be separated by `T`. For more information, see [RFC 3339 section 5.6, Internet Date/Time Format](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
         *
         * If you provide values for both `StartTime` and `EndTime`, Security Hub returns finding history for the specified time period. If you provide a value for `StartTime` but not for `EndTime`, Security Hub returns finding history from the `StartTime` to the time at which the API is called. If you provide a value for `EndTime` but not for `StartTime`, Security Hub returns finding history from the [CreatedAt](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_AwsSecurityFindingFilters.html#securityhub-Type-AwsSecurityFindingFilters-CreatedAt) timestamp of the finding to the `EndTime`. If you provide neither `StartTime` nor `EndTime`, Security Hub returns finding history from the CreatedAt timestamp of the finding to the time at which the API is called. In all of these scenarios, the response is limited to 100 results, and the maximum time period is limited to 90 days.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Identifies which finding to get the finding history for.
         */
        public var findingIdentifier: aws.sdk.kotlin.services.securityhub.model.AwsSecurityFindingIdentifier? = null
        /**
         * The maximum number of results to be returned. If you don’t provide it, Security Hub returns up to 100 results of finding history.
         */
        public var maxResults: kotlin.Int = 0
        /**
         * A token for pagination purposes. Provide `NULL` as the initial value. In subsequent requests, provide the token included in the response to get up to an additional 100 results of finding history. If you don’t provide `NextToken`, Security Hub returns up to 100 results of finding history for each request.
         */
        public var nextToken: kotlin.String? = null
        /**
         * An ISO 8601-formatted timestamp that indicates the start time of the requested finding history. A correctly formatted example is `2020-05-21T20:16:34.724Z`. The value cannot contain spaces, and date and time should be separated by `T`. For more information, see [RFC 3339 section 5.6, Internet Date/Time Format](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
         *
         * If you provide values for both `StartTime` and `EndTime`, Security Hub returns finding history for the specified time period. If you provide a value for `StartTime` but not for `EndTime`, Security Hub returns finding history from the `StartTime` to the time at which the API is called. If you provide a value for `EndTime` but not for `StartTime`, Security Hub returns finding history from the [CreatedAt](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_AwsSecurityFindingFilters.html#securityhub-Type-AwsSecurityFindingFilters-CreatedAt) timestamp of the finding to the `EndTime`. If you provide neither `StartTime` nor `EndTime`, Security Hub returns finding history from the CreatedAt timestamp of the finding to the time at which the API is called. In all of these scenarios, the response is limited to 100 results, and the maximum time period is limited to 90 days.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.GetFindingHistoryRequest) : this() {
            this.endTime = x.endTime
            this.findingIdentifier = x.findingIdentifier
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.GetFindingHistoryRequest = GetFindingHistoryRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsSecurityFindingIdentifier] inside the given [block]
         */
        public fun findingIdentifier(block: aws.sdk.kotlin.services.securityhub.model.AwsSecurityFindingIdentifier.Builder.() -> kotlin.Unit) {
            this.findingIdentifier = aws.sdk.kotlin.services.securityhub.model.AwsSecurityFindingIdentifier.invoke(block)
        }
    }
}
