// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * An array of objects that provides details about a change to a finding, including the Amazon Web Services Security Finding Format (ASFF) field that changed, the value of the field before the change, and the value of the field after the change.
 */
public class FindingHistoryUpdate private constructor(builder: Builder) {
    /**
     * The value of the ASFF field after the finding change event. To preserve storage and readability, Security Hub omits this value if `FindingHistoryRecord`[](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_FindingHistoryRecord.html) exceeds database limits.
     */
    public val newValue: kotlin.String? = builder.newValue
    /**
     * The value of the ASFF field before the finding change event.
     */
    public val oldValue: kotlin.String? = builder.oldValue
    /**
     * The ASFF field that changed during the finding change event.
     */
    public val updatedField: kotlin.String? = builder.updatedField

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.FindingHistoryUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FindingHistoryUpdate(")
        append("newValue=$newValue,")
        append("oldValue=$oldValue,")
        append("updatedField=$updatedField")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = newValue?.hashCode() ?: 0
        result = 31 * result + (oldValue?.hashCode() ?: 0)
        result = 31 * result + (updatedField?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FindingHistoryUpdate

        if (newValue != other.newValue) return false
        if (oldValue != other.oldValue) return false
        if (updatedField != other.updatedField) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.FindingHistoryUpdate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The value of the ASFF field after the finding change event. To preserve storage and readability, Security Hub omits this value if `FindingHistoryRecord`[](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_FindingHistoryRecord.html) exceeds database limits.
         */
        public var newValue: kotlin.String? = null
        /**
         * The value of the ASFF field before the finding change event.
         */
        public var oldValue: kotlin.String? = null
        /**
         * The ASFF field that changed during the finding change event.
         */
        public var updatedField: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.FindingHistoryUpdate) : this() {
            this.newValue = x.newValue
            this.oldValue = x.oldValue
            this.updatedField = x.updatedField
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.FindingHistoryUpdate = FindingHistoryUpdate(this)
    }
}
