// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Contains finding details that are specific to control-based findings. Only returned for findings generated from controls.
 */
public class Compliance private constructor(builder: Builder) {
    /**
     * The enabled security standards in which a security control is currently enabled.
     */
    public val associatedStandards: List<AssociatedStandard>? = builder.associatedStandards
    /**
     * For a control, the industry or regulatory framework requirements that are related to the control. The check for that control is aligned with these requirements.
     */
    public val relatedRequirements: List<String>? = builder.relatedRequirements
    /**
     * The unique identifier of a control across standards. Values for this field typically consist of an Amazon Web Service and a number, such as APIGateway.5.
     */
    public val securityControlId: kotlin.String? = builder.securityControlId
    /**
     * The result of a standards check.
     *
     * The valid values for `Status` are as follows.
     * +
     *    + `PASSED` - Standards check passed for all evaluated resources.
     *    + `WARNING` - Some information is missing or this check is not supported for your configuration.
     *    + `FAILED` - Standards check failed for at least one evaluated resource.
     *    + `NOT_AVAILABLE` - Check could not be performed due to a service outage, API error, or because the result of the Config evaluation was `NOT_APPLICABLE`. If the Config evaluation result was `NOT_APPLICABLE`, then after 3 days, Security Hub automatically archives the finding.
     */
    public val status: aws.sdk.kotlin.services.securityhub.model.ComplianceStatus? = builder.status
    /**
     * For findings generated from controls, a list of reasons behind the value of `Status`. For the list of status reason codes and their meanings, see [Standards-related information in the ASFF](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-results.html#securityhub-standards-results-asff) in the *Security Hub User Guide*.
     */
    public val statusReasons: List<StatusReason>? = builder.statusReasons

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.Compliance = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Compliance(")
        append("associatedStandards=$associatedStandards,")
        append("relatedRequirements=$relatedRequirements,")
        append("securityControlId=$securityControlId,")
        append("status=$status,")
        append("statusReasons=$statusReasons")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatedStandards?.hashCode() ?: 0
        result = 31 * result + (relatedRequirements?.hashCode() ?: 0)
        result = 31 * result + (securityControlId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReasons?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Compliance

        if (associatedStandards != other.associatedStandards) return false
        if (relatedRequirements != other.relatedRequirements) return false
        if (securityControlId != other.securityControlId) return false
        if (status != other.status) return false
        if (statusReasons != other.statusReasons) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.Compliance = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The enabled security standards in which a security control is currently enabled.
         */
        public var associatedStandards: List<AssociatedStandard>? = null
        /**
         * For a control, the industry or regulatory framework requirements that are related to the control. The check for that control is aligned with these requirements.
         */
        public var relatedRequirements: List<String>? = null
        /**
         * The unique identifier of a control across standards. Values for this field typically consist of an Amazon Web Service and a number, such as APIGateway.5.
         */
        public var securityControlId: kotlin.String? = null
        /**
         * The result of a standards check.
         *
         * The valid values for `Status` are as follows.
         * +
         *    + `PASSED` - Standards check passed for all evaluated resources.
         *    + `WARNING` - Some information is missing or this check is not supported for your configuration.
         *    + `FAILED` - Standards check failed for at least one evaluated resource.
         *    + `NOT_AVAILABLE` - Check could not be performed due to a service outage, API error, or because the result of the Config evaluation was `NOT_APPLICABLE`. If the Config evaluation result was `NOT_APPLICABLE`, then after 3 days, Security Hub automatically archives the finding.
         */
        public var status: aws.sdk.kotlin.services.securityhub.model.ComplianceStatus? = null
        /**
         * For findings generated from controls, a list of reasons behind the value of `Status`. For the list of status reason codes and their meanings, see [Standards-related information in the ASFF](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-results.html#securityhub-standards-results-asff) in the *Security Hub User Guide*.
         */
        public var statusReasons: List<StatusReason>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.Compliance) : this() {
            this.associatedStandards = x.associatedStandards
            this.relatedRequirements = x.relatedRequirements
            this.securityControlId = x.securityControlId
            this.status = x.status
            this.statusReasons = x.statusReasons
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.Compliance = Compliance(this)
    }
}
