// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * A finding from a `BatchUpdateFindings` request that Security Hub was unable to update.
 */
public class BatchUpdateFindingsUnprocessedFinding private constructor(builder: Builder) {
    /**
     * The code associated with the error. Possible values are:
     * + `ConcurrentUpdateError` - Another request attempted to update the finding while this request was being processed. This error may also occur if you call `BatchUpdateFindings`[](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateFindings.html) and `BatchImportFindings`[](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchImportFindings.html) at the same time.
     * + `DuplicatedFindingIdentifier` - The request included two or more findings with the same `FindingIdentifier`.
     * + `FindingNotFound` - The `FindingIdentifier` included in the request did not match an existing finding.
     * + `FindingSizeExceeded` - The finding size was greater than the permissible value of 240 KB.
     * + `InternalFailure` - An internal service failure occurred when updating the finding.
     * + `InvalidInput` - The finding update contained an invalid value that did not satisfy the [Amazon Web Services Security Finding Format](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html) syntax.
     */
    public val errorCode: kotlin.String? = builder.errorCode
    /**
     * The message associated with the error. Possible values are:
     * + `Concurrent finding updates detected`
     * + `Finding Identifier is duplicated`
     * + `Finding Not Found`
     * + `Finding size exceeded 240 KB`
     * + `Internal service failure`
     * + `Invalid Input`
     */
    public val errorMessage: kotlin.String? = builder.errorMessage
    /**
     * The identifier of the finding that was not updated.
     */
    public val findingIdentifier: aws.sdk.kotlin.services.securityhub.model.AwsSecurityFindingIdentifier? = builder.findingIdentifier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.BatchUpdateFindingsUnprocessedFinding = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchUpdateFindingsUnprocessedFinding(")
        append("errorCode=$errorCode,")
        append("errorMessage=$errorMessage,")
        append("findingIdentifier=$findingIdentifier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = errorCode?.hashCode() ?: 0
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        result = 31 * result + (findingIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchUpdateFindingsUnprocessedFinding

        if (errorCode != other.errorCode) return false
        if (errorMessage != other.errorMessage) return false
        if (findingIdentifier != other.findingIdentifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.BatchUpdateFindingsUnprocessedFinding = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The code associated with the error. Possible values are:
         * + `ConcurrentUpdateError` - Another request attempted to update the finding while this request was being processed. This error may also occur if you call `BatchUpdateFindings`[](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateFindings.html) and `BatchImportFindings`[](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchImportFindings.html) at the same time.
         * + `DuplicatedFindingIdentifier` - The request included two or more findings with the same `FindingIdentifier`.
         * + `FindingNotFound` - The `FindingIdentifier` included in the request did not match an existing finding.
         * + `FindingSizeExceeded` - The finding size was greater than the permissible value of 240 KB.
         * + `InternalFailure` - An internal service failure occurred when updating the finding.
         * + `InvalidInput` - The finding update contained an invalid value that did not satisfy the [Amazon Web Services Security Finding Format](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html) syntax.
         */
        public var errorCode: kotlin.String? = null
        /**
         * The message associated with the error. Possible values are:
         * + `Concurrent finding updates detected`
         * + `Finding Identifier is duplicated`
         * + `Finding Not Found`
         * + `Finding size exceeded 240 KB`
         * + `Internal service failure`
         * + `Invalid Input`
         */
        public var errorMessage: kotlin.String? = null
        /**
         * The identifier of the finding that was not updated.
         */
        public var findingIdentifier: aws.sdk.kotlin.services.securityhub.model.AwsSecurityFindingIdentifier? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.BatchUpdateFindingsUnprocessedFinding) : this() {
            this.errorCode = x.errorCode
            this.errorMessage = x.errorMessage
            this.findingIdentifier = x.findingIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.BatchUpdateFindingsUnprocessedFinding = BatchUpdateFindingsUnprocessedFinding(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsSecurityFindingIdentifier] inside the given [block]
         */
        public fun findingIdentifier(block: aws.sdk.kotlin.services.securityhub.model.AwsSecurityFindingIdentifier.Builder.() -> kotlin.Unit) {
            this.findingIdentifier = aws.sdk.kotlin.services.securityhub.model.AwsSecurityFindingIdentifier.invoke(block)
        }
    }
}
