// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides information about an Amazon SNS topic to which notifications can be published.
 */
public class AwsSnsTopicDetails private constructor(builder: Builder) {
    /**
     * Indicates failed message delivery status for an Amazon SNS topic that is subscribed to a platform application endpoint.
     */
    public val applicationSuccessFeedbackRoleArn: kotlin.String? = builder.applicationSuccessFeedbackRoleArn
    /**
     * Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an Amazon Kinesis Data Firehose endpoint.
     */
    public val firehoseFailureFeedbackRoleArn: kotlin.String? = builder.firehoseFailureFeedbackRoleArn
    /**
     * Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an Amazon Kinesis Data Firehose endpoint.
     */
    public val firehoseSuccessFeedbackRoleArn: kotlin.String? = builder.firehoseSuccessFeedbackRoleArn
    /**
     * Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an HTTP endpoint.
     */
    public val httpFailureFeedbackRoleArn: kotlin.String? = builder.httpFailureFeedbackRoleArn
    /**
     * Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an HTTP endpoint.
     */
    public val httpSuccessFeedbackRoleArn: kotlin.String? = builder.httpSuccessFeedbackRoleArn
    /**
     * The ID of an Amazon Web Services managed key for Amazon SNS or a customer managed key.
     */
    public val kmsMasterKeyId: kotlin.String? = builder.kmsMasterKeyId
    /**
     * The subscription's owner.
     */
    public val owner: kotlin.String? = builder.owner
    /**
     * Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an Amazon SQS endpoint.
     */
    public val sqsFailureFeedbackRoleArn: kotlin.String? = builder.sqsFailureFeedbackRoleArn
    /**
     * Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an Amazon SQS endpoint.
     */
    public val sqsSuccessFeedbackRoleArn: kotlin.String? = builder.sqsSuccessFeedbackRoleArn
    /**
     * Subscription is an embedded property that describes the subscription endpoints of an Amazon SNS topic.
     */
    public val subscription: List<AwsSnsTopicSubscription>? = builder.subscription
    /**
     * The name of the Amazon SNS topic.
     */
    public val topicName: kotlin.String? = builder.topicName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsSnsTopicDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsSnsTopicDetails(")
        append("applicationSuccessFeedbackRoleArn=$applicationSuccessFeedbackRoleArn,")
        append("firehoseFailureFeedbackRoleArn=$firehoseFailureFeedbackRoleArn,")
        append("firehoseSuccessFeedbackRoleArn=$firehoseSuccessFeedbackRoleArn,")
        append("httpFailureFeedbackRoleArn=$httpFailureFeedbackRoleArn,")
        append("httpSuccessFeedbackRoleArn=$httpSuccessFeedbackRoleArn,")
        append("kmsMasterKeyId=$kmsMasterKeyId,")
        append("owner=$owner,")
        append("sqsFailureFeedbackRoleArn=$sqsFailureFeedbackRoleArn,")
        append("sqsSuccessFeedbackRoleArn=$sqsSuccessFeedbackRoleArn,")
        append("subscription=$subscription,")
        append("topicName=$topicName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationSuccessFeedbackRoleArn?.hashCode() ?: 0
        result = 31 * result + (firehoseFailureFeedbackRoleArn?.hashCode() ?: 0)
        result = 31 * result + (firehoseSuccessFeedbackRoleArn?.hashCode() ?: 0)
        result = 31 * result + (httpFailureFeedbackRoleArn?.hashCode() ?: 0)
        result = 31 * result + (httpSuccessFeedbackRoleArn?.hashCode() ?: 0)
        result = 31 * result + (kmsMasterKeyId?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (sqsFailureFeedbackRoleArn?.hashCode() ?: 0)
        result = 31 * result + (sqsSuccessFeedbackRoleArn?.hashCode() ?: 0)
        result = 31 * result + (subscription?.hashCode() ?: 0)
        result = 31 * result + (topicName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsSnsTopicDetails

        if (applicationSuccessFeedbackRoleArn != other.applicationSuccessFeedbackRoleArn) return false
        if (firehoseFailureFeedbackRoleArn != other.firehoseFailureFeedbackRoleArn) return false
        if (firehoseSuccessFeedbackRoleArn != other.firehoseSuccessFeedbackRoleArn) return false
        if (httpFailureFeedbackRoleArn != other.httpFailureFeedbackRoleArn) return false
        if (httpSuccessFeedbackRoleArn != other.httpSuccessFeedbackRoleArn) return false
        if (kmsMasterKeyId != other.kmsMasterKeyId) return false
        if (owner != other.owner) return false
        if (sqsFailureFeedbackRoleArn != other.sqsFailureFeedbackRoleArn) return false
        if (sqsSuccessFeedbackRoleArn != other.sqsSuccessFeedbackRoleArn) return false
        if (subscription != other.subscription) return false
        if (topicName != other.topicName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsSnsTopicDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates failed message delivery status for an Amazon SNS topic that is subscribed to a platform application endpoint.
         */
        public var applicationSuccessFeedbackRoleArn: kotlin.String? = null
        /**
         * Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an Amazon Kinesis Data Firehose endpoint.
         */
        public var firehoseFailureFeedbackRoleArn: kotlin.String? = null
        /**
         * Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an Amazon Kinesis Data Firehose endpoint.
         */
        public var firehoseSuccessFeedbackRoleArn: kotlin.String? = null
        /**
         * Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an HTTP endpoint.
         */
        public var httpFailureFeedbackRoleArn: kotlin.String? = null
        /**
         * Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an HTTP endpoint.
         */
        public var httpSuccessFeedbackRoleArn: kotlin.String? = null
        /**
         * The ID of an Amazon Web Services managed key for Amazon SNS or a customer managed key.
         */
        public var kmsMasterKeyId: kotlin.String? = null
        /**
         * The subscription's owner.
         */
        public var owner: kotlin.String? = null
        /**
         * Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an Amazon SQS endpoint.
         */
        public var sqsFailureFeedbackRoleArn: kotlin.String? = null
        /**
         * Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an Amazon SQS endpoint.
         */
        public var sqsSuccessFeedbackRoleArn: kotlin.String? = null
        /**
         * Subscription is an embedded property that describes the subscription endpoints of an Amazon SNS topic.
         */
        public var subscription: List<AwsSnsTopicSubscription>? = null
        /**
         * The name of the Amazon SNS topic.
         */
        public var topicName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsSnsTopicDetails) : this() {
            this.applicationSuccessFeedbackRoleArn = x.applicationSuccessFeedbackRoleArn
            this.firehoseFailureFeedbackRoleArn = x.firehoseFailureFeedbackRoleArn
            this.firehoseSuccessFeedbackRoleArn = x.firehoseSuccessFeedbackRoleArn
            this.httpFailureFeedbackRoleArn = x.httpFailureFeedbackRoleArn
            this.httpSuccessFeedbackRoleArn = x.httpSuccessFeedbackRoleArn
            this.kmsMasterKeyId = x.kmsMasterKeyId
            this.owner = x.owner
            this.sqsFailureFeedbackRoleArn = x.sqsFailureFeedbackRoleArn
            this.sqsSuccessFeedbackRoleArn = x.sqsSuccessFeedbackRoleArn
            this.subscription = x.subscription
            this.topicName = x.topicName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsSnsTopicDetails = AwsSnsTopicDetails(this)
    }
}
