// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * You can configure Amazon Redshift to copy snapshots for a cluster to another Amazon Web Services Region. This parameter provides information about a cross-Region snapshot copy.
 */
public class AwsRedshiftClusterClusterSnapshotCopyStatus private constructor(builder: Builder) {
    /**
     * The destination Region that snapshots are automatically copied to when cross-Region snapshot copy is enabled.
     */
    public val destinationRegion: kotlin.String? = builder.destinationRegion
    /**
     * The number of days that manual snapshots are retained in the destination Region after they are copied from a source Region.
     *
     * If the value is `-1`, then the manual snapshot is retained indefinitely.
     *
     * Valid values: Either `-1` or an integer between 1 and 3,653
     */
    public val manualSnapshotRetentionPeriod: kotlin.Int = builder.manualSnapshotRetentionPeriod
    /**
     * The number of days to retain automated snapshots in the destination Region after they are copied from a source Region.
     */
    public val retentionPeriod: kotlin.Int = builder.retentionPeriod
    /**
     * The name of the snapshot copy grant.
     */
    public val snapshotCopyGrantName: kotlin.String? = builder.snapshotCopyGrantName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterClusterSnapshotCopyStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsRedshiftClusterClusterSnapshotCopyStatus(")
        append("destinationRegion=$destinationRegion,")
        append("manualSnapshotRetentionPeriod=$manualSnapshotRetentionPeriod,")
        append("retentionPeriod=$retentionPeriod,")
        append("snapshotCopyGrantName=$snapshotCopyGrantName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationRegion?.hashCode() ?: 0
        result = 31 * result + (manualSnapshotRetentionPeriod)
        result = 31 * result + (retentionPeriod)
        result = 31 * result + (snapshotCopyGrantName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsRedshiftClusterClusterSnapshotCopyStatus

        if (destinationRegion != other.destinationRegion) return false
        if (manualSnapshotRetentionPeriod != other.manualSnapshotRetentionPeriod) return false
        if (retentionPeriod != other.retentionPeriod) return false
        if (snapshotCopyGrantName != other.snapshotCopyGrantName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterClusterSnapshotCopyStatus = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The destination Region that snapshots are automatically copied to when cross-Region snapshot copy is enabled.
         */
        public var destinationRegion: kotlin.String? = null
        /**
         * The number of days that manual snapshots are retained in the destination Region after they are copied from a source Region.
         *
         * If the value is `-1`, then the manual snapshot is retained indefinitely.
         *
         * Valid values: Either `-1` or an integer between 1 and 3,653
         */
        public var manualSnapshotRetentionPeriod: kotlin.Int = 0
        /**
         * The number of days to retain automated snapshots in the destination Region after they are copied from a source Region.
         */
        public var retentionPeriod: kotlin.Int = 0
        /**
         * The name of the snapshot copy grant.
         */
        public var snapshotCopyGrantName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterClusterSnapshotCopyStatus) : this() {
            this.destinationRegion = x.destinationRegion
            this.manualSnapshotRetentionPeriod = x.manualSnapshotRetentionPeriod
            this.retentionPeriod = x.retentionPeriod
            this.snapshotCopyGrantName = x.snapshotCopyGrantName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterClusterSnapshotCopyStatus = AwsRedshiftClusterClusterSnapshotCopyStatus(this)
    }
}
