// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Information about an Amazon RDS DB cluster snapshot.
 */
public class AwsRdsDbClusterSnapshotDetails private constructor(builder: Builder) {
    /**
     * Specifies the allocated storage size in gibibytes (GiB).
     */
    public val allocatedStorage: kotlin.Int = builder.allocatedStorage
    /**
     * A list of Availability Zones where instances in the DB cluster can be created.
     */
    public val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * Indicates when the DB cluster was created, in Universal Coordinated Time (UTC).
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val clusterCreateTime: kotlin.String? = builder.clusterCreateTime
    /**
     * The DB cluster identifier.
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The identifier of the DB cluster snapshot.
     */
    public val dbClusterSnapshotIdentifier: kotlin.String? = builder.dbClusterSnapshotIdentifier
    /**
     * The name of the database engine that you want to use for this DB instance.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The version of the database engine to use.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * Whether mapping of IAM accounts to database accounts is enabled.
     */
    public val iamDatabaseAuthenticationEnabled: kotlin.Boolean = builder.iamDatabaseAuthenticationEnabled
    /**
     * The ARN of the KMS master key that is used to encrypt the database instances in the DB cluster.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The license model information for this DB cluster snapshot.
     */
    public val licenseModel: kotlin.String? = builder.licenseModel
    /**
     * The name of the master user for the DB cluster.
     */
    public val masterUsername: kotlin.String? = builder.masterUsername
    /**
     * Specifies the percentage of the estimated data that has been transferred.
     */
    public val percentProgress: kotlin.Int = builder.percentProgress
    /**
     * The port number on which the DB instances in the DB cluster accept connections.
     */
    public val port: kotlin.Int = builder.port
    /**
     * Indicates when the snapshot was taken.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val snapshotCreateTime: kotlin.String? = builder.snapshotCreateTime
    /**
     * The type of DB cluster snapshot.
     */
    public val snapshotType: kotlin.String? = builder.snapshotType
    /**
     * The status of this DB cluster snapshot.
     */
    public val status: kotlin.String? = builder.status
    /**
     * Whether the DB cluster is encrypted.
     */
    public val storageEncrypted: kotlin.Boolean = builder.storageEncrypted
    /**
     * The VPC ID that is associated with the DB cluster snapshot.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsRdsDbClusterSnapshotDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsRdsDbClusterSnapshotDetails(")
        append("allocatedStorage=$allocatedStorage,")
        append("availabilityZones=$availabilityZones,")
        append("clusterCreateTime=$clusterCreateTime,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbClusterSnapshotIdentifier=$dbClusterSnapshotIdentifier,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("iamDatabaseAuthenticationEnabled=$iamDatabaseAuthenticationEnabled,")
        append("kmsKeyId=$kmsKeyId,")
        append("licenseModel=$licenseModel,")
        append("masterUsername=$masterUsername,")
        append("percentProgress=$percentProgress,")
        append("port=$port,")
        append("snapshotCreateTime=$snapshotCreateTime,")
        append("snapshotType=$snapshotType,")
        append("status=$status,")
        append("storageEncrypted=$storageEncrypted,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage
        result = 31 * result + (availabilityZones?.hashCode() ?: 0)
        result = 31 * result + (clusterCreateTime?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbClusterSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (iamDatabaseAuthenticationEnabled.hashCode())
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (licenseModel?.hashCode() ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (percentProgress)
        result = 31 * result + (port)
        result = 31 * result + (snapshotCreateTime?.hashCode() ?: 0)
        result = 31 * result + (snapshotType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (storageEncrypted.hashCode())
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsRdsDbClusterSnapshotDetails

        if (allocatedStorage != other.allocatedStorage) return false
        if (availabilityZones != other.availabilityZones) return false
        if (clusterCreateTime != other.clusterCreateTime) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbClusterSnapshotIdentifier != other.dbClusterSnapshotIdentifier) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (iamDatabaseAuthenticationEnabled != other.iamDatabaseAuthenticationEnabled) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (licenseModel != other.licenseModel) return false
        if (masterUsername != other.masterUsername) return false
        if (percentProgress != other.percentProgress) return false
        if (port != other.port) return false
        if (snapshotCreateTime != other.snapshotCreateTime) return false
        if (snapshotType != other.snapshotType) return false
        if (status != other.status) return false
        if (storageEncrypted != other.storageEncrypted) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsRdsDbClusterSnapshotDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the allocated storage size in gibibytes (GiB).
         */
        public var allocatedStorage: kotlin.Int = 0
        /**
         * A list of Availability Zones where instances in the DB cluster can be created.
         */
        public var availabilityZones: List<String>? = null
        /**
         * Indicates when the DB cluster was created, in Universal Coordinated Time (UTC).
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var clusterCreateTime: kotlin.String? = null
        /**
         * The DB cluster identifier.
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * The identifier of the DB cluster snapshot.
         */
        public var dbClusterSnapshotIdentifier: kotlin.String? = null
        /**
         * The name of the database engine that you want to use for this DB instance.
         */
        public var engine: kotlin.String? = null
        /**
         * The version of the database engine to use.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * Whether mapping of IAM accounts to database accounts is enabled.
         */
        public var iamDatabaseAuthenticationEnabled: kotlin.Boolean = false
        /**
         * The ARN of the KMS master key that is used to encrypt the database instances in the DB cluster.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The license model information for this DB cluster snapshot.
         */
        public var licenseModel: kotlin.String? = null
        /**
         * The name of the master user for the DB cluster.
         */
        public var masterUsername: kotlin.String? = null
        /**
         * Specifies the percentage of the estimated data that has been transferred.
         */
        public var percentProgress: kotlin.Int = 0
        /**
         * The port number on which the DB instances in the DB cluster accept connections.
         */
        public var port: kotlin.Int = 0
        /**
         * Indicates when the snapshot was taken.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var snapshotCreateTime: kotlin.String? = null
        /**
         * The type of DB cluster snapshot.
         */
        public var snapshotType: kotlin.String? = null
        /**
         * The status of this DB cluster snapshot.
         */
        public var status: kotlin.String? = null
        /**
         * Whether the DB cluster is encrypted.
         */
        public var storageEncrypted: kotlin.Boolean = false
        /**
         * The VPC ID that is associated with the DB cluster snapshot.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsRdsDbClusterSnapshotDetails) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.availabilityZones = x.availabilityZones
            this.clusterCreateTime = x.clusterCreateTime
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbClusterSnapshotIdentifier = x.dbClusterSnapshotIdentifier
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.iamDatabaseAuthenticationEnabled = x.iamDatabaseAuthenticationEnabled
            this.kmsKeyId = x.kmsKeyId
            this.licenseModel = x.licenseModel
            this.masterUsername = x.masterUsername
            this.percentProgress = x.percentProgress
            this.port = x.port
            this.snapshotCreateTime = x.snapshotCreateTime
            this.snapshotType = x.snapshotType
            this.status = x.status
            this.storageEncrypted = x.storageEncrypted
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsRdsDbClusterSnapshotDetails = AwsRdsDbClusterSnapshotDetails(this)
    }
}
