// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Information about an Amazon RDS DB cluster.
 */
public class AwsRdsDbClusterDetails private constructor(builder: Builder) {
    /**
     * The status of the database activity stream. Valid values are as follows:
     * + `started`
     * + `starting`
     * + `stopped`
     * + `stopping`
     */
    public val activityStreamStatus: kotlin.String? = builder.activityStreamStatus
    /**
     * For all database engines except Aurora, specifies the allocated storage size in gibibytes (GiB).
     */
    public val allocatedStorage: kotlin.Int = builder.allocatedStorage
    /**
     * A list of the IAM roles that are associated with the DB cluster.
     */
    public val associatedRoles: List<AwsRdsDbClusterAssociatedRole>? = builder.associatedRoles
    /**
     * A list of Availability Zones (AZs) where instances in the DB cluster can be created.
     */
    public val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * The number of days for which automated backups are retained.
     */
    public val backupRetentionPeriod: kotlin.Int = builder.backupRetentionPeriod
    /**
     * Indicates when the DB cluster was created, in Universal Coordinated Time (UTC).
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val clusterCreateTime: kotlin.String? = builder.clusterCreateTime
    /**
     * Whether tags are copied from the DB cluster to snapshots of the DB cluster.
     */
    public val copyTagsToSnapshot: kotlin.Boolean = builder.copyTagsToSnapshot
    /**
     * Whether the DB cluster is a clone of a DB cluster owned by a different Amazon Web Services account.
     */
    public val crossAccountClone: kotlin.Boolean = builder.crossAccountClone
    /**
     * A list of custom endpoints for the DB cluster.
     */
    public val customEndpoints: List<String>? = builder.customEndpoints
    /**
     * The name of the database.
     */
    public val databaseName: kotlin.String? = builder.databaseName
    /**
     * The DB cluster identifier that the user assigned to the cluster. This identifier is the unique key that identifies a DB cluster.
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The list of instances that make up the DB cluster.
     */
    public val dbClusterMembers: List<AwsRdsDbClusterMember>? = builder.dbClusterMembers
    /**
     * The list of option group memberships for this DB cluster.
     */
    public val dbClusterOptionGroupMemberships: List<AwsRdsDbClusterOptionGroupMembership>? = builder.dbClusterOptionGroupMemberships
    /**
     * The name of the DB cluster parameter group for the DB cluster.
     */
    public val dbClusterParameterGroup: kotlin.String? = builder.dbClusterParameterGroup
    /**
     * The identifier of the DB cluster. The identifier must be unique within each Amazon Web Services Region and is immutable.
     */
    public val dbClusterResourceId: kotlin.String? = builder.dbClusterResourceId
    /**
     * The subnet group that is associated with the DB cluster, including the name, description, and subnets in the subnet group.
     */
    public val dbSubnetGroup: kotlin.String? = builder.dbSubnetGroup
    /**
     * Whether the DB cluster has deletion protection enabled.
     */
    public val deletionProtection: kotlin.Boolean = builder.deletionProtection
    /**
     * The Active Directory domain membership records that are associated with the DB cluster.
     */
    public val domainMemberships: List<AwsRdsDbDomainMembership>? = builder.domainMemberships
    /**
     * A list of log types that this DB cluster is configured to export to CloudWatch Logs.
     */
    public val enabledCloudWatchLogsExports: List<String>? = builder.enabledCloudWatchLogsExports
    /**
     * The connection endpoint for the primary instance of the DB cluster.
     */
    public val endpoint: kotlin.String? = builder.endpoint
    /**
     * The name of the database engine to use for this DB cluster. Valid values are as follows:
     * + `aurora`
     * + `aurora-mysql`
     * + `aurora-postgresql`
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The database engine mode of the DB cluster.Valid values are as follows:
     * + `global`
     * + `multimaster`
     * + `parallelquery`
     * + `provisioned`
     * + `serverless`
     */
    public val engineMode: kotlin.String? = builder.engineMode
    /**
     * The version number of the database engine to use.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * Specifies the identifier that Amazon Route 53 assigns when you create a hosted zone.
     */
    public val hostedZoneId: kotlin.String? = builder.hostedZoneId
    /**
     * Whether the HTTP endpoint for an Aurora Serverless DB cluster is enabled.
     */
    public val httpEndpointEnabled: kotlin.Boolean = builder.httpEndpointEnabled
    /**
     * Whether the mapping of IAM accounts to database accounts is enabled.
     */
    public val iamDatabaseAuthenticationEnabled: kotlin.Boolean = builder.iamDatabaseAuthenticationEnabled
    /**
     * The ARN of the KMS master key that is used to encrypt the database instances in the DB cluster.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The name of the master user for the DB cluster.
     */
    public val masterUsername: kotlin.String? = builder.masterUsername
    /**
     * Whether the DB cluster has instances in multiple Availability Zones.
     */
    public val multiAz: kotlin.Boolean = builder.multiAz
    /**
     * The port number on which the DB instances in the DB cluster accept connections.
     */
    public val port: kotlin.Int = builder.port
    /**
     * The range of time each day when automated backups are created, if automated backups are enabled.
     *
     * Uses the format `HH:MM-HH:MM`. For example, `04:52-05:22`.
     */
    public val preferredBackupWindow: kotlin.String? = builder.preferredBackupWindow
    /**
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     *
     * Uses the format `<day>:HH:MM-<day>:HH:MM`.
     *
     * For the day values, use `mon`|`tue`|`wed`|`thu`|`fri`|`sat`|`sun`.
     *
     * For example, `sun:09:32-sun:10:02`.
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * The identifiers of the read replicas that are associated with this DB cluster.
     */
    public val readReplicaIdentifiers: List<String>? = builder.readReplicaIdentifiers
    /**
     * The reader endpoint for the DB cluster.
     */
    public val readerEndpoint: kotlin.String? = builder.readerEndpoint
    /**
     * The current status of this DB cluster.
     */
    public val status: kotlin.String? = builder.status
    /**
     * Whether the DB cluster is encrypted.
     */
    public val storageEncrypted: kotlin.Boolean = builder.storageEncrypted
    /**
     * A list of VPC security groups that the DB cluster belongs to.
     */
    public val vpcSecurityGroups: List<AwsRdsDbInstanceVpcSecurityGroup>? = builder.vpcSecurityGroups

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsRdsDbClusterDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsRdsDbClusterDetails(")
        append("activityStreamStatus=$activityStreamStatus,")
        append("allocatedStorage=$allocatedStorage,")
        append("associatedRoles=$associatedRoles,")
        append("availabilityZones=$availabilityZones,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("clusterCreateTime=$clusterCreateTime,")
        append("copyTagsToSnapshot=$copyTagsToSnapshot,")
        append("crossAccountClone=$crossAccountClone,")
        append("customEndpoints=$customEndpoints,")
        append("databaseName=$databaseName,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbClusterMembers=$dbClusterMembers,")
        append("dbClusterOptionGroupMemberships=$dbClusterOptionGroupMemberships,")
        append("dbClusterParameterGroup=$dbClusterParameterGroup,")
        append("dbClusterResourceId=$dbClusterResourceId,")
        append("dbSubnetGroup=$dbSubnetGroup,")
        append("deletionProtection=$deletionProtection,")
        append("domainMemberships=$domainMemberships,")
        append("enabledCloudWatchLogsExports=$enabledCloudWatchLogsExports,")
        append("endpoint=$endpoint,")
        append("engine=$engine,")
        append("engineMode=$engineMode,")
        append("engineVersion=$engineVersion,")
        append("hostedZoneId=$hostedZoneId,")
        append("httpEndpointEnabled=$httpEndpointEnabled,")
        append("iamDatabaseAuthenticationEnabled=$iamDatabaseAuthenticationEnabled,")
        append("kmsKeyId=$kmsKeyId,")
        append("masterUsername=$masterUsername,")
        append("multiAz=$multiAz,")
        append("port=$port,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("readReplicaIdentifiers=$readReplicaIdentifiers,")
        append("readerEndpoint=$readerEndpoint,")
        append("status=$status,")
        append("storageEncrypted=$storageEncrypted,")
        append("vpcSecurityGroups=$vpcSecurityGroups")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activityStreamStatus?.hashCode() ?: 0
        result = 31 * result + (allocatedStorage)
        result = 31 * result + (associatedRoles?.hashCode() ?: 0)
        result = 31 * result + (availabilityZones?.hashCode() ?: 0)
        result = 31 * result + (backupRetentionPeriod)
        result = 31 * result + (clusterCreateTime?.hashCode() ?: 0)
        result = 31 * result + (copyTagsToSnapshot.hashCode())
        result = 31 * result + (crossAccountClone.hashCode())
        result = 31 * result + (customEndpoints?.hashCode() ?: 0)
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbClusterMembers?.hashCode() ?: 0)
        result = 31 * result + (dbClusterOptionGroupMemberships?.hashCode() ?: 0)
        result = 31 * result + (dbClusterParameterGroup?.hashCode() ?: 0)
        result = 31 * result + (dbClusterResourceId?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroup?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection.hashCode())
        result = 31 * result + (domainMemberships?.hashCode() ?: 0)
        result = 31 * result + (enabledCloudWatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineMode?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (hostedZoneId?.hashCode() ?: 0)
        result = 31 * result + (httpEndpointEnabled.hashCode())
        result = 31 * result + (iamDatabaseAuthenticationEnabled.hashCode())
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (multiAz.hashCode())
        result = 31 * result + (port)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (readReplicaIdentifiers?.hashCode() ?: 0)
        result = 31 * result + (readerEndpoint?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (storageEncrypted.hashCode())
        result = 31 * result + (vpcSecurityGroups?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsRdsDbClusterDetails

        if (activityStreamStatus != other.activityStreamStatus) return false
        if (allocatedStorage != other.allocatedStorage) return false
        if (associatedRoles != other.associatedRoles) return false
        if (availabilityZones != other.availabilityZones) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (clusterCreateTime != other.clusterCreateTime) return false
        if (copyTagsToSnapshot != other.copyTagsToSnapshot) return false
        if (crossAccountClone != other.crossAccountClone) return false
        if (customEndpoints != other.customEndpoints) return false
        if (databaseName != other.databaseName) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbClusterMembers != other.dbClusterMembers) return false
        if (dbClusterOptionGroupMemberships != other.dbClusterOptionGroupMemberships) return false
        if (dbClusterParameterGroup != other.dbClusterParameterGroup) return false
        if (dbClusterResourceId != other.dbClusterResourceId) return false
        if (dbSubnetGroup != other.dbSubnetGroup) return false
        if (deletionProtection != other.deletionProtection) return false
        if (domainMemberships != other.domainMemberships) return false
        if (enabledCloudWatchLogsExports != other.enabledCloudWatchLogsExports) return false
        if (endpoint != other.endpoint) return false
        if (engine != other.engine) return false
        if (engineMode != other.engineMode) return false
        if (engineVersion != other.engineVersion) return false
        if (hostedZoneId != other.hostedZoneId) return false
        if (httpEndpointEnabled != other.httpEndpointEnabled) return false
        if (iamDatabaseAuthenticationEnabled != other.iamDatabaseAuthenticationEnabled) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (masterUsername != other.masterUsername) return false
        if (multiAz != other.multiAz) return false
        if (port != other.port) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (readReplicaIdentifiers != other.readReplicaIdentifiers) return false
        if (readerEndpoint != other.readerEndpoint) return false
        if (status != other.status) return false
        if (storageEncrypted != other.storageEncrypted) return false
        if (vpcSecurityGroups != other.vpcSecurityGroups) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsRdsDbClusterDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The status of the database activity stream. Valid values are as follows:
         * + `started`
         * + `starting`
         * + `stopped`
         * + `stopping`
         */
        public var activityStreamStatus: kotlin.String? = null
        /**
         * For all database engines except Aurora, specifies the allocated storage size in gibibytes (GiB).
         */
        public var allocatedStorage: kotlin.Int = 0
        /**
         * A list of the IAM roles that are associated with the DB cluster.
         */
        public var associatedRoles: List<AwsRdsDbClusterAssociatedRole>? = null
        /**
         * A list of Availability Zones (AZs) where instances in the DB cluster can be created.
         */
        public var availabilityZones: List<String>? = null
        /**
         * The number of days for which automated backups are retained.
         */
        public var backupRetentionPeriod: kotlin.Int = 0
        /**
         * Indicates when the DB cluster was created, in Universal Coordinated Time (UTC).
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var clusterCreateTime: kotlin.String? = null
        /**
         * Whether tags are copied from the DB cluster to snapshots of the DB cluster.
         */
        public var copyTagsToSnapshot: kotlin.Boolean = false
        /**
         * Whether the DB cluster is a clone of a DB cluster owned by a different Amazon Web Services account.
         */
        public var crossAccountClone: kotlin.Boolean = false
        /**
         * A list of custom endpoints for the DB cluster.
         */
        public var customEndpoints: List<String>? = null
        /**
         * The name of the database.
         */
        public var databaseName: kotlin.String? = null
        /**
         * The DB cluster identifier that the user assigned to the cluster. This identifier is the unique key that identifies a DB cluster.
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * The list of instances that make up the DB cluster.
         */
        public var dbClusterMembers: List<AwsRdsDbClusterMember>? = null
        /**
         * The list of option group memberships for this DB cluster.
         */
        public var dbClusterOptionGroupMemberships: List<AwsRdsDbClusterOptionGroupMembership>? = null
        /**
         * The name of the DB cluster parameter group for the DB cluster.
         */
        public var dbClusterParameterGroup: kotlin.String? = null
        /**
         * The identifier of the DB cluster. The identifier must be unique within each Amazon Web Services Region and is immutable.
         */
        public var dbClusterResourceId: kotlin.String? = null
        /**
         * The subnet group that is associated with the DB cluster, including the name, description, and subnets in the subnet group.
         */
        public var dbSubnetGroup: kotlin.String? = null
        /**
         * Whether the DB cluster has deletion protection enabled.
         */
        public var deletionProtection: kotlin.Boolean = false
        /**
         * The Active Directory domain membership records that are associated with the DB cluster.
         */
        public var domainMemberships: List<AwsRdsDbDomainMembership>? = null
        /**
         * A list of log types that this DB cluster is configured to export to CloudWatch Logs.
         */
        public var enabledCloudWatchLogsExports: List<String>? = null
        /**
         * The connection endpoint for the primary instance of the DB cluster.
         */
        public var endpoint: kotlin.String? = null
        /**
         * The name of the database engine to use for this DB cluster. Valid values are as follows:
         * + `aurora`
         * + `aurora-mysql`
         * + `aurora-postgresql`
         */
        public var engine: kotlin.String? = null
        /**
         * The database engine mode of the DB cluster.Valid values are as follows:
         * + `global`
         * + `multimaster`
         * + `parallelquery`
         * + `provisioned`
         * + `serverless`
         */
        public var engineMode: kotlin.String? = null
        /**
         * The version number of the database engine to use.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * Specifies the identifier that Amazon Route 53 assigns when you create a hosted zone.
         */
        public var hostedZoneId: kotlin.String? = null
        /**
         * Whether the HTTP endpoint for an Aurora Serverless DB cluster is enabled.
         */
        public var httpEndpointEnabled: kotlin.Boolean = false
        /**
         * Whether the mapping of IAM accounts to database accounts is enabled.
         */
        public var iamDatabaseAuthenticationEnabled: kotlin.Boolean = false
        /**
         * The ARN of the KMS master key that is used to encrypt the database instances in the DB cluster.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The name of the master user for the DB cluster.
         */
        public var masterUsername: kotlin.String? = null
        /**
         * Whether the DB cluster has instances in multiple Availability Zones.
         */
        public var multiAz: kotlin.Boolean = false
        /**
         * The port number on which the DB instances in the DB cluster accept connections.
         */
        public var port: kotlin.Int = 0
        /**
         * The range of time each day when automated backups are created, if automated backups are enabled.
         *
         * Uses the format `HH:MM-HH:MM`. For example, `04:52-05:22`.
         */
        public var preferredBackupWindow: kotlin.String? = null
        /**
         * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         *
         * Uses the format `<day>:HH:MM-<day>:HH:MM`.
         *
         * For the day values, use `mon`|`tue`|`wed`|`thu`|`fri`|`sat`|`sun`.
         *
         * For example, `sun:09:32-sun:10:02`.
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * The identifiers of the read replicas that are associated with this DB cluster.
         */
        public var readReplicaIdentifiers: List<String>? = null
        /**
         * The reader endpoint for the DB cluster.
         */
        public var readerEndpoint: kotlin.String? = null
        /**
         * The current status of this DB cluster.
         */
        public var status: kotlin.String? = null
        /**
         * Whether the DB cluster is encrypted.
         */
        public var storageEncrypted: kotlin.Boolean = false
        /**
         * A list of VPC security groups that the DB cluster belongs to.
         */
        public var vpcSecurityGroups: List<AwsRdsDbInstanceVpcSecurityGroup>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsRdsDbClusterDetails) : this() {
            this.activityStreamStatus = x.activityStreamStatus
            this.allocatedStorage = x.allocatedStorage
            this.associatedRoles = x.associatedRoles
            this.availabilityZones = x.availabilityZones
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.clusterCreateTime = x.clusterCreateTime
            this.copyTagsToSnapshot = x.copyTagsToSnapshot
            this.crossAccountClone = x.crossAccountClone
            this.customEndpoints = x.customEndpoints
            this.databaseName = x.databaseName
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbClusterMembers = x.dbClusterMembers
            this.dbClusterOptionGroupMemberships = x.dbClusterOptionGroupMemberships
            this.dbClusterParameterGroup = x.dbClusterParameterGroup
            this.dbClusterResourceId = x.dbClusterResourceId
            this.dbSubnetGroup = x.dbSubnetGroup
            this.deletionProtection = x.deletionProtection
            this.domainMemberships = x.domainMemberships
            this.enabledCloudWatchLogsExports = x.enabledCloudWatchLogsExports
            this.endpoint = x.endpoint
            this.engine = x.engine
            this.engineMode = x.engineMode
            this.engineVersion = x.engineVersion
            this.hostedZoneId = x.hostedZoneId
            this.httpEndpointEnabled = x.httpEndpointEnabled
            this.iamDatabaseAuthenticationEnabled = x.iamDatabaseAuthenticationEnabled
            this.kmsKeyId = x.kmsKeyId
            this.masterUsername = x.masterUsername
            this.multiAz = x.multiAz
            this.port = x.port
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.readReplicaIdentifiers = x.readReplicaIdentifiers
            this.readerEndpoint = x.readerEndpoint
            this.status = x.status
            this.storageEncrypted = x.storageEncrypted
            this.vpcSecurityGroups = x.vpcSecurityGroups
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsRdsDbClusterDetails = AwsRdsDbClusterDetails(this)
    }
}
