// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Details about an Network Firewall rule group. Rule groups are used to inspect and control network traffic. Stateless rule groups apply to individual packets. Stateful rule groups apply to packets in the context of their traffic flow.
 *
 * Rule groups are referenced in firewall policies.
 */
public class AwsNetworkFirewallRuleGroupDetails private constructor(builder: Builder) {
    /**
     * The maximum number of operating resources that this rule group can use.
     */
    public val capacity: kotlin.Int = builder.capacity
    /**
     * A description of the rule group.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Details about the rule group.
     */
    public val ruleGroup: aws.sdk.kotlin.services.securityhub.model.RuleGroupDetails? = builder.ruleGroup
    /**
     * The ARN of the rule group.
     */
    public val ruleGroupArn: kotlin.String? = builder.ruleGroupArn
    /**
     * The identifier of the rule group.
     */
    public val ruleGroupId: kotlin.String? = builder.ruleGroupId
    /**
     * The descriptive name of the rule group.
     */
    public val ruleGroupName: kotlin.String? = builder.ruleGroupName
    /**
     * The type of rule group. A rule group can be stateful or stateless.
     */
    public val type: kotlin.String? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsNetworkFirewallRuleGroupDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsNetworkFirewallRuleGroupDetails(")
        append("capacity=$capacity,")
        append("description=$description,")
        append("ruleGroup=$ruleGroup,")
        append("ruleGroupArn=$ruleGroupArn,")
        append("ruleGroupId=$ruleGroupId,")
        append("ruleGroupName=$ruleGroupName,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacity
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (ruleGroup?.hashCode() ?: 0)
        result = 31 * result + (ruleGroupArn?.hashCode() ?: 0)
        result = 31 * result + (ruleGroupId?.hashCode() ?: 0)
        result = 31 * result + (ruleGroupName?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsNetworkFirewallRuleGroupDetails

        if (capacity != other.capacity) return false
        if (description != other.description) return false
        if (ruleGroup != other.ruleGroup) return false
        if (ruleGroupArn != other.ruleGroupArn) return false
        if (ruleGroupId != other.ruleGroupId) return false
        if (ruleGroupName != other.ruleGroupName) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsNetworkFirewallRuleGroupDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of operating resources that this rule group can use.
         */
        public var capacity: kotlin.Int = 0
        /**
         * A description of the rule group.
         */
        public var description: kotlin.String? = null
        /**
         * Details about the rule group.
         */
        public var ruleGroup: aws.sdk.kotlin.services.securityhub.model.RuleGroupDetails? = null
        /**
         * The ARN of the rule group.
         */
        public var ruleGroupArn: kotlin.String? = null
        /**
         * The identifier of the rule group.
         */
        public var ruleGroupId: kotlin.String? = null
        /**
         * The descriptive name of the rule group.
         */
        public var ruleGroupName: kotlin.String? = null
        /**
         * The type of rule group. A rule group can be stateful or stateless.
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsNetworkFirewallRuleGroupDetails) : this() {
            this.capacity = x.capacity
            this.description = x.description
            this.ruleGroup = x.ruleGroup
            this.ruleGroupArn = x.ruleGroupArn
            this.ruleGroupId = x.ruleGroupId
            this.ruleGroupName = x.ruleGroupName
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsNetworkFirewallRuleGroupDetails = AwsNetworkFirewallRuleGroupDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.RuleGroupDetails] inside the given [block]
         */
        public fun ruleGroup(block: aws.sdk.kotlin.services.securityhub.model.RuleGroupDetails.Builder.() -> kotlin.Unit) {
            this.ruleGroup = aws.sdk.kotlin.services.securityhub.model.RuleGroupDetails.invoke(block)
        }
    }
}
