// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Details about an Lambda function's configuration.
 */
public class AwsLambdaFunctionDetails private constructor(builder: Builder) {
    /**
     * The instruction set architecture that the function uses. Valid values are `x86_64` or `arm64`.
     */
    public val architectures: List<String>? = builder.architectures
    /**
     * An `AwsLambdaFunctionCode` object.
     */
    public val code: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionCode? = builder.code
    /**
     * The SHA256 hash of the function's deployment package.
     */
    public val codeSha256: kotlin.String? = builder.codeSha256
    /**
     * The function's dead letter queue.
     */
    public val deadLetterConfig: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionDeadLetterConfig? = builder.deadLetterConfig
    /**
     * The function's environment variables.
     */
    public val environment: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionEnvironment? = builder.environment
    /**
     * The name of the function.
     */
    public val functionName: kotlin.String? = builder.functionName
    /**
     * The function that Lambda calls to begin executing your function.
     */
    public val handler: kotlin.String? = builder.handler
    /**
     * The KMS key that is used to encrypt the function's environment variables. This key is only returned if you've configured a customer managed customer managed key.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * Indicates when the function was last updated.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val lastModified: kotlin.String? = builder.lastModified
    /**
     * The function's layers.
     */
    public val layers: List<AwsLambdaFunctionLayer>? = builder.layers
    /**
     * For Lambda@Edge functions, the ARN of the master function.
     */
    public val masterArn: kotlin.String? = builder.masterArn
    /**
     * The memory that is allocated to the function.
     */
    public val memorySize: kotlin.Int = builder.memorySize
    /**
     * The type of deployment package that's used to deploy the function code to Lambda. Set to `Image` for a container image and `Zip` for a .zip file archive.
     */
    public val packageType: kotlin.String? = builder.packageType
    /**
     * The latest updated revision of the function or alias.
     */
    public val revisionId: kotlin.String? = builder.revisionId
    /**
     * The function's execution role.
     */
    public val role: kotlin.String? = builder.role
    /**
     * The runtime environment for the Lambda function.
     */
    public val runtime: kotlin.String? = builder.runtime
    /**
     * The amount of time that Lambda allows a function to run before stopping it.
     */
    public val timeout: kotlin.Int = builder.timeout
    /**
     * The function's X-Ray tracing configuration.
     */
    public val tracingConfig: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionTracingConfig? = builder.tracingConfig
    /**
     * The version of the Lambda function.
     */
    public val version: kotlin.String? = builder.version
    /**
     * The function's networking configuration.
     */
    public val vpcConfig: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionVpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsLambdaFunctionDetails(")
        append("architectures=$architectures,")
        append("code=$code,")
        append("codeSha256=$codeSha256,")
        append("deadLetterConfig=$deadLetterConfig,")
        append("environment=$environment,")
        append("functionName=$functionName,")
        append("handler=$handler,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("lastModified=$lastModified,")
        append("layers=$layers,")
        append("masterArn=$masterArn,")
        append("memorySize=$memorySize,")
        append("packageType=$packageType,")
        append("revisionId=$revisionId,")
        append("role=$role,")
        append("runtime=$runtime,")
        append("timeout=$timeout,")
        append("tracingConfig=$tracingConfig,")
        append("version=$version,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = architectures?.hashCode() ?: 0
        result = 31 * result + (code?.hashCode() ?: 0)
        result = 31 * result + (codeSha256?.hashCode() ?: 0)
        result = 31 * result + (deadLetterConfig?.hashCode() ?: 0)
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (functionName?.hashCode() ?: 0)
        result = 31 * result + (handler?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (lastModified?.hashCode() ?: 0)
        result = 31 * result + (layers?.hashCode() ?: 0)
        result = 31 * result + (masterArn?.hashCode() ?: 0)
        result = 31 * result + (memorySize)
        result = 31 * result + (packageType?.hashCode() ?: 0)
        result = 31 * result + (revisionId?.hashCode() ?: 0)
        result = 31 * result + (role?.hashCode() ?: 0)
        result = 31 * result + (runtime?.hashCode() ?: 0)
        result = 31 * result + (timeout)
        result = 31 * result + (tracingConfig?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsLambdaFunctionDetails

        if (architectures != other.architectures) return false
        if (code != other.code) return false
        if (codeSha256 != other.codeSha256) return false
        if (deadLetterConfig != other.deadLetterConfig) return false
        if (environment != other.environment) return false
        if (functionName != other.functionName) return false
        if (handler != other.handler) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (lastModified != other.lastModified) return false
        if (layers != other.layers) return false
        if (masterArn != other.masterArn) return false
        if (memorySize != other.memorySize) return false
        if (packageType != other.packageType) return false
        if (revisionId != other.revisionId) return false
        if (role != other.role) return false
        if (runtime != other.runtime) return false
        if (timeout != other.timeout) return false
        if (tracingConfig != other.tracingConfig) return false
        if (version != other.version) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The instruction set architecture that the function uses. Valid values are `x86_64` or `arm64`.
         */
        public var architectures: List<String>? = null
        /**
         * An `AwsLambdaFunctionCode` object.
         */
        public var code: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionCode? = null
        /**
         * The SHA256 hash of the function's deployment package.
         */
        public var codeSha256: kotlin.String? = null
        /**
         * The function's dead letter queue.
         */
        public var deadLetterConfig: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionDeadLetterConfig? = null
        /**
         * The function's environment variables.
         */
        public var environment: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionEnvironment? = null
        /**
         * The name of the function.
         */
        public var functionName: kotlin.String? = null
        /**
         * The function that Lambda calls to begin executing your function.
         */
        public var handler: kotlin.String? = null
        /**
         * The KMS key that is used to encrypt the function's environment variables. This key is only returned if you've configured a customer managed customer managed key.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * Indicates when the function was last updated.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var lastModified: kotlin.String? = null
        /**
         * The function's layers.
         */
        public var layers: List<AwsLambdaFunctionLayer>? = null
        /**
         * For Lambda@Edge functions, the ARN of the master function.
         */
        public var masterArn: kotlin.String? = null
        /**
         * The memory that is allocated to the function.
         */
        public var memorySize: kotlin.Int = 0
        /**
         * The type of deployment package that's used to deploy the function code to Lambda. Set to `Image` for a container image and `Zip` for a .zip file archive.
         */
        public var packageType: kotlin.String? = null
        /**
         * The latest updated revision of the function or alias.
         */
        public var revisionId: kotlin.String? = null
        /**
         * The function's execution role.
         */
        public var role: kotlin.String? = null
        /**
         * The runtime environment for the Lambda function.
         */
        public var runtime: kotlin.String? = null
        /**
         * The amount of time that Lambda allows a function to run before stopping it.
         */
        public var timeout: kotlin.Int = 0
        /**
         * The function's X-Ray tracing configuration.
         */
        public var tracingConfig: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionTracingConfig? = null
        /**
         * The version of the Lambda function.
         */
        public var version: kotlin.String? = null
        /**
         * The function's networking configuration.
         */
        public var vpcConfig: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionVpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionDetails) : this() {
            this.architectures = x.architectures
            this.code = x.code
            this.codeSha256 = x.codeSha256
            this.deadLetterConfig = x.deadLetterConfig
            this.environment = x.environment
            this.functionName = x.functionName
            this.handler = x.handler
            this.kmsKeyArn = x.kmsKeyArn
            this.lastModified = x.lastModified
            this.layers = x.layers
            this.masterArn = x.masterArn
            this.memorySize = x.memorySize
            this.packageType = x.packageType
            this.revisionId = x.revisionId
            this.role = x.role
            this.runtime = x.runtime
            this.timeout = x.timeout
            this.tracingConfig = x.tracingConfig
            this.version = x.version
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionDetails = AwsLambdaFunctionDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionCode] inside the given [block]
         */
        public fun code(block: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionCode.Builder.() -> kotlin.Unit) {
            this.code = aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionCode.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionDeadLetterConfig] inside the given [block]
         */
        public fun deadLetterConfig(block: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionDeadLetterConfig.Builder.() -> kotlin.Unit) {
            this.deadLetterConfig = aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionDeadLetterConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionEnvironment] inside the given [block]
         */
        public fun environment(block: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionEnvironment.Builder.() -> kotlin.Unit) {
            this.environment = aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionEnvironment.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionTracingConfig] inside the given [block]
         */
        public fun tracingConfig(block: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionTracingConfig.Builder.() -> kotlin.Unit) {
            this.tracingConfig = aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionTracingConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionVpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionVpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionVpcConfig.invoke(block)
        }
    }
}
