// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Information about a load balancer.
 */
public class AwsElbv2LoadBalancerDetails private constructor(builder: Builder) {
    /**
     * The Availability Zones for the load balancer.
     */
    public val availabilityZones: List<AvailabilityZone>? = builder.availabilityZones
    /**
     * The ID of the Amazon Route 53 hosted zone associated with the load balancer.
     */
    public val canonicalHostedZoneId: kotlin.String? = builder.canonicalHostedZoneId
    /**
     * Indicates when the load balancer was created.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val createdTime: kotlin.String? = builder.createdTime
    /**
     * The public DNS name of the load balancer.
     */
    public val dnsName: kotlin.String? = builder.dnsName
    /**
     * The type of IP addresses used by the subnets for your load balancer. The possible values are `ipv4` (for IPv4 addresses) and `dualstack` (for IPv4 and IPv6 addresses).
     */
    public val ipAddressType: kotlin.String? = builder.ipAddressType
    /**
     * Attributes of the load balancer.
     */
    public val loadBalancerAttributes: List<AwsElbv2LoadBalancerAttribute>? = builder.loadBalancerAttributes
    /**
     * The nodes of an Internet-facing load balancer have public IP addresses.
     */
    public val scheme: kotlin.String? = builder.scheme
    /**
     * The IDs of the security groups for the load balancer.
     */
    public val securityGroups: List<String>? = builder.securityGroups
    /**
     * The state of the load balancer.
     */
    public val state: aws.sdk.kotlin.services.securityhub.model.LoadBalancerState? = builder.state
    /**
     * The type of load balancer.
     */
    public val type: kotlin.String? = builder.type
    /**
     * The ID of the VPC for the load balancer.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsElbv2LoadBalancerDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsElbv2LoadBalancerDetails(")
        append("availabilityZones=$availabilityZones,")
        append("canonicalHostedZoneId=$canonicalHostedZoneId,")
        append("createdTime=$createdTime,")
        append("dnsName=$dnsName,")
        append("ipAddressType=$ipAddressType,")
        append("loadBalancerAttributes=$loadBalancerAttributes,")
        append("scheme=$scheme,")
        append("securityGroups=$securityGroups,")
        append("state=$state,")
        append("type=$type,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZones?.hashCode() ?: 0
        result = 31 * result + (canonicalHostedZoneId?.hashCode() ?: 0)
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (dnsName?.hashCode() ?: 0)
        result = 31 * result + (ipAddressType?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerAttributes?.hashCode() ?: 0)
        result = 31 * result + (scheme?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsElbv2LoadBalancerDetails

        if (availabilityZones != other.availabilityZones) return false
        if (canonicalHostedZoneId != other.canonicalHostedZoneId) return false
        if (createdTime != other.createdTime) return false
        if (dnsName != other.dnsName) return false
        if (ipAddressType != other.ipAddressType) return false
        if (loadBalancerAttributes != other.loadBalancerAttributes) return false
        if (scheme != other.scheme) return false
        if (securityGroups != other.securityGroups) return false
        if (state != other.state) return false
        if (type != other.type) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsElbv2LoadBalancerDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Availability Zones for the load balancer.
         */
        public var availabilityZones: List<AvailabilityZone>? = null
        /**
         * The ID of the Amazon Route 53 hosted zone associated with the load balancer.
         */
        public var canonicalHostedZoneId: kotlin.String? = null
        /**
         * Indicates when the load balancer was created.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var createdTime: kotlin.String? = null
        /**
         * The public DNS name of the load balancer.
         */
        public var dnsName: kotlin.String? = null
        /**
         * The type of IP addresses used by the subnets for your load balancer. The possible values are `ipv4` (for IPv4 addresses) and `dualstack` (for IPv4 and IPv6 addresses).
         */
        public var ipAddressType: kotlin.String? = null
        /**
         * Attributes of the load balancer.
         */
        public var loadBalancerAttributes: List<AwsElbv2LoadBalancerAttribute>? = null
        /**
         * The nodes of an Internet-facing load balancer have public IP addresses.
         */
        public var scheme: kotlin.String? = null
        /**
         * The IDs of the security groups for the load balancer.
         */
        public var securityGroups: List<String>? = null
        /**
         * The state of the load balancer.
         */
        public var state: aws.sdk.kotlin.services.securityhub.model.LoadBalancerState? = null
        /**
         * The type of load balancer.
         */
        public var type: kotlin.String? = null
        /**
         * The ID of the VPC for the load balancer.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsElbv2LoadBalancerDetails) : this() {
            this.availabilityZones = x.availabilityZones
            this.canonicalHostedZoneId = x.canonicalHostedZoneId
            this.createdTime = x.createdTime
            this.dnsName = x.dnsName
            this.ipAddressType = x.ipAddressType
            this.loadBalancerAttributes = x.loadBalancerAttributes
            this.scheme = x.scheme
            this.securityGroups = x.securityGroups
            this.state = x.state
            this.type = x.type
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsElbv2LoadBalancerDetails = AwsElbv2LoadBalancerDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.LoadBalancerState] inside the given [block]
         */
        public fun state(block: aws.sdk.kotlin.services.securityhub.model.LoadBalancerState.Builder.() -> kotlin.Unit) {
            this.state = aws.sdk.kotlin.services.securityhub.model.LoadBalancerState.invoke(block)
        }
    }
}
