// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Information about a load balancer that the service uses.
 */
public class AwsEcsServiceLoadBalancersDetails private constructor(builder: Builder) {
    /**
     * The name of the container to associate with the load balancer.
     */
    public val containerName: kotlin.String? = builder.containerName
    /**
     * The port on the container to associate with the load balancer. This port must correspond to a `containerPort` in the task definition the tasks in the service are using. For tasks that use the EC2 launch type, the container instance they are launched on must allow ingress traffic on the `hostPort` of the port mapping.
     */
    public val containerPort: kotlin.Int = builder.containerPort
    /**
     * The name of the load balancer to associate with the Amazon ECS service or task set.
     *
     * Only specified when using a Classic Load Balancer. For an Application Load Balancer or a Network Load Balancer, the load balancer name is omitted.
     */
    public val loadBalancerName: kotlin.String? = builder.loadBalancerName
    /**
     * The ARN of the Elastic Load Balancing target group or groups associated with a service or task set.
     *
     * Only specified when using an Application Load Balancer or a Network Load Balancer. For a Classic Load Balancer, the target group ARN is omitted.
     */
    public val targetGroupArn: kotlin.String? = builder.targetGroupArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceLoadBalancersDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsEcsServiceLoadBalancersDetails(")
        append("containerName=$containerName,")
        append("containerPort=$containerPort,")
        append("loadBalancerName=$loadBalancerName,")
        append("targetGroupArn=$targetGroupArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerName?.hashCode() ?: 0
        result = 31 * result + (containerPort)
        result = 31 * result + (loadBalancerName?.hashCode() ?: 0)
        result = 31 * result + (targetGroupArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsEcsServiceLoadBalancersDetails

        if (containerName != other.containerName) return false
        if (containerPort != other.containerPort) return false
        if (loadBalancerName != other.loadBalancerName) return false
        if (targetGroupArn != other.targetGroupArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceLoadBalancersDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the container to associate with the load balancer.
         */
        public var containerName: kotlin.String? = null
        /**
         * The port on the container to associate with the load balancer. This port must correspond to a `containerPort` in the task definition the tasks in the service are using. For tasks that use the EC2 launch type, the container instance they are launched on must allow ingress traffic on the `hostPort` of the port mapping.
         */
        public var containerPort: kotlin.Int = 0
        /**
         * The name of the load balancer to associate with the Amazon ECS service or task set.
         *
         * Only specified when using a Classic Load Balancer. For an Application Load Balancer or a Network Load Balancer, the load balancer name is omitted.
         */
        public var loadBalancerName: kotlin.String? = null
        /**
         * The ARN of the Elastic Load Balancing target group or groups associated with a service or task set.
         *
         * Only specified when using an Application Load Balancer or a Network Load Balancer. For a Classic Load Balancer, the target group ARN is omitted.
         */
        public var targetGroupArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceLoadBalancersDetails) : this() {
            this.containerName = x.containerName
            this.containerPort = x.containerPort
            this.loadBalancerName = x.loadBalancerName
            this.targetGroupArn = x.targetGroupArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceLoadBalancersDetails = AwsEcsServiceLoadBalancersDetails(this)
    }
}
