// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Optional deployment parameters for the service.
 */
public class AwsEcsServiceDeploymentConfigurationDetails private constructor(builder: Builder) {
    /**
     * Determines whether a service deployment fails if a service cannot reach a steady state.
     */
    public val deploymentCircuitBreaker: aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails? = builder.deploymentCircuitBreaker
    /**
     * For a service that uses the rolling update (`ECS`) deployment type, the maximum number of tasks in a service that are allowed in the `RUNNING` or `PENDING` state during a deployment, and for tasks that use the EC2 launch type, when any container instances are in the `DRAINING` state. Provided as a percentage of the desired number of tasks. The default value is 200%.
     *
     * For a service that uses the blue/green (`CODE_DEPLOY`) or `EXTERNAL` deployment types, and tasks that use the EC2 launch type, the maximum number of tasks in the service that remain in the `RUNNING` state while the container instances are in the `DRAINING` state.
     *
     * For the Fargate launch type, the maximum percent value is not used.
     */
    public val maximumPercent: kotlin.Int = builder.maximumPercent
    /**
     * For a service that uses the rolling update (`ECS`) deployment type, the minimum number of tasks in a service that must remain in the `RUNNING` state during a deployment, and while any container instances are in the `DRAINING` state if the service contains tasks using the EC2 launch type. Expressed as a percentage of the desired number of tasks. The default value is 100%.
     *
     * For a service that uses the blue/green (`CODE_DEPLOY`) or `EXTERNAL` deployment types and tasks that use the EC2 launch type, the minimum number of the tasks in the service that remain in the `RUNNING` state while the container instances are in the `DRAINING` state.
     *
     * For the Fargate launch type, the minimum healthy percent value is not used.
     */
    public val minimumHealthyPercent: kotlin.Int = builder.minimumHealthyPercent

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceDeploymentConfigurationDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsEcsServiceDeploymentConfigurationDetails(")
        append("deploymentCircuitBreaker=$deploymentCircuitBreaker,")
        append("maximumPercent=$maximumPercent,")
        append("minimumHealthyPercent=$minimumHealthyPercent")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentCircuitBreaker?.hashCode() ?: 0
        result = 31 * result + (maximumPercent)
        result = 31 * result + (minimumHealthyPercent)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsEcsServiceDeploymentConfigurationDetails

        if (deploymentCircuitBreaker != other.deploymentCircuitBreaker) return false
        if (maximumPercent != other.maximumPercent) return false
        if (minimumHealthyPercent != other.minimumHealthyPercent) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceDeploymentConfigurationDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Determines whether a service deployment fails if a service cannot reach a steady state.
         */
        public var deploymentCircuitBreaker: aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails? = null
        /**
         * For a service that uses the rolling update (`ECS`) deployment type, the maximum number of tasks in a service that are allowed in the `RUNNING` or `PENDING` state during a deployment, and for tasks that use the EC2 launch type, when any container instances are in the `DRAINING` state. Provided as a percentage of the desired number of tasks. The default value is 200%.
         *
         * For a service that uses the blue/green (`CODE_DEPLOY`) or `EXTERNAL` deployment types, and tasks that use the EC2 launch type, the maximum number of tasks in the service that remain in the `RUNNING` state while the container instances are in the `DRAINING` state.
         *
         * For the Fargate launch type, the maximum percent value is not used.
         */
        public var maximumPercent: kotlin.Int = 0
        /**
         * For a service that uses the rolling update (`ECS`) deployment type, the minimum number of tasks in a service that must remain in the `RUNNING` state during a deployment, and while any container instances are in the `DRAINING` state if the service contains tasks using the EC2 launch type. Expressed as a percentage of the desired number of tasks. The default value is 100%.
         *
         * For a service that uses the blue/green (`CODE_DEPLOY`) or `EXTERNAL` deployment types and tasks that use the EC2 launch type, the minimum number of the tasks in the service that remain in the `RUNNING` state while the container instances are in the `DRAINING` state.
         *
         * For the Fargate launch type, the minimum healthy percent value is not used.
         */
        public var minimumHealthyPercent: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceDeploymentConfigurationDetails) : this() {
            this.deploymentCircuitBreaker = x.deploymentCircuitBreaker
            this.maximumPercent = x.maximumPercent
            this.minimumHealthyPercent = x.minimumHealthyPercent
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceDeploymentConfigurationDetails = AwsEcsServiceDeploymentConfigurationDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails] inside the given [block]
         */
        public fun deploymentCircuitBreaker(block: aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails.Builder.() -> kotlin.Unit) {
            this.deploymentCircuitBreaker = aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails.invoke(block)
        }
    }
}
