// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Strategy item for the capacity provider strategy that the service uses.
 */
public class AwsEcsServiceCapacityProviderStrategyDetails private constructor(builder: Builder) {
    /**
     * The minimum number of tasks to run on the capacity provider. Only one strategy item can specify a value for `Base`.
     *
     * The value must be between 0 and 100000.
     */
    public val base: kotlin.Int = builder.base
    /**
     * The short name of the capacity provider.
     */
    public val capacityProvider: kotlin.String? = builder.capacityProvider
    /**
     * The relative percentage of the total number of tasks that should use the capacity provider.
     *
     * If no weight is specified, the default value is 0. At least one capacity provider must have a weight greater than 0.
     *
     * The value can be between 0 and 1000.
     */
    public val weight: kotlin.Int = builder.weight

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsEcsServiceCapacityProviderStrategyDetails(")
        append("base=$base,")
        append("capacityProvider=$capacityProvider,")
        append("weight=$weight")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = base
        result = 31 * result + (capacityProvider?.hashCode() ?: 0)
        result = 31 * result + (weight)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsEcsServiceCapacityProviderStrategyDetails

        if (base != other.base) return false
        if (capacityProvider != other.capacityProvider) return false
        if (weight != other.weight) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The minimum number of tasks to run on the capacity provider. Only one strategy item can specify a value for `Base`.
         *
         * The value must be between 0 and 100000.
         */
        public var base: kotlin.Int = 0
        /**
         * The short name of the capacity provider.
         */
        public var capacityProvider: kotlin.String? = null
        /**
         * The relative percentage of the total number of tasks that should use the capacity provider.
         *
         * If no weight is specified, the default value is 0. At least one capacity provider must have a weight greater than 0.
         *
         * The value can be between 0 and 1000.
         */
        public var weight: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails) : this() {
            this.base = x.base
            this.capacityProvider = x.capacityProvider
            this.weight = x.weight
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails = AwsEcsServiceCapacityProviderStrategyDetails(this)
    }
}
