// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Information about an Amazon Web Services Amazon EC2 Transit Gateway that interconnects virtual private clouds (VPCs) and on-premises networks.
 */
public class AwsEc2TransitGatewayDetails private constructor(builder: Builder) {
    /**
     * A private Autonomous System Number (ASN) for the Amazon side of a BGP session.
     */
    public val amazonSideAsn: kotlin.Int = builder.amazonSideAsn
    /**
     * The ID of the default association route table.
     */
    public val associationDefaultRouteTableId: kotlin.String? = builder.associationDefaultRouteTableId
    /**
     * Turn on or turn off automatic acceptance of attachment requests.
     */
    public val autoAcceptSharedAttachments: kotlin.String? = builder.autoAcceptSharedAttachments
    /**
     * Turn on or turn off automatic association with the default association route table.
     */
    public val defaultRouteTableAssociation: kotlin.String? = builder.defaultRouteTableAssociation
    /**
     * Turn on or turn off automatic propagation of routes to the default propagation route table.
     */
    public val defaultRouteTablePropagation: kotlin.String? = builder.defaultRouteTablePropagation
    /**
     * The description of the transit gateway.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Turn on or turn off DNS support.
     */
    public val dnsSupport: kotlin.String? = builder.dnsSupport
    /**
     * The ID of the transit gateway.
     */
    public val id: kotlin.String? = builder.id
    /**
     * Indicates whether multicast is supported on the transit gateway.
     */
    public val multicastSupport: kotlin.String? = builder.multicastSupport
    /**
     * The ID of the default propagation route table.
     */
    public val propagationDefaultRouteTableId: kotlin.String? = builder.propagationDefaultRouteTableId
    /**
     * The transit gateway Classless Inter-Domain Routing (CIDR) blocks.
     */
    public val transitGatewayCidrBlocks: List<String>? = builder.transitGatewayCidrBlocks
    /**
     * Turn on or turn off Equal Cost Multipath Protocol (ECMP) support.
     */
    public val vpnEcmpSupport: kotlin.String? = builder.vpnEcmpSupport

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsEc2TransitGatewayDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsEc2TransitGatewayDetails(")
        append("amazonSideAsn=$amazonSideAsn,")
        append("associationDefaultRouteTableId=$associationDefaultRouteTableId,")
        append("autoAcceptSharedAttachments=$autoAcceptSharedAttachments,")
        append("defaultRouteTableAssociation=$defaultRouteTableAssociation,")
        append("defaultRouteTablePropagation=$defaultRouteTablePropagation,")
        append("description=$description,")
        append("dnsSupport=$dnsSupport,")
        append("id=$id,")
        append("multicastSupport=$multicastSupport,")
        append("propagationDefaultRouteTableId=$propagationDefaultRouteTableId,")
        append("transitGatewayCidrBlocks=$transitGatewayCidrBlocks,")
        append("vpnEcmpSupport=$vpnEcmpSupport")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = amazonSideAsn
        result = 31 * result + (associationDefaultRouteTableId?.hashCode() ?: 0)
        result = 31 * result + (autoAcceptSharedAttachments?.hashCode() ?: 0)
        result = 31 * result + (defaultRouteTableAssociation?.hashCode() ?: 0)
        result = 31 * result + (defaultRouteTablePropagation?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (dnsSupport?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (multicastSupport?.hashCode() ?: 0)
        result = 31 * result + (propagationDefaultRouteTableId?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayCidrBlocks?.hashCode() ?: 0)
        result = 31 * result + (vpnEcmpSupport?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsEc2TransitGatewayDetails

        if (amazonSideAsn != other.amazonSideAsn) return false
        if (associationDefaultRouteTableId != other.associationDefaultRouteTableId) return false
        if (autoAcceptSharedAttachments != other.autoAcceptSharedAttachments) return false
        if (defaultRouteTableAssociation != other.defaultRouteTableAssociation) return false
        if (defaultRouteTablePropagation != other.defaultRouteTablePropagation) return false
        if (description != other.description) return false
        if (dnsSupport != other.dnsSupport) return false
        if (id != other.id) return false
        if (multicastSupport != other.multicastSupport) return false
        if (propagationDefaultRouteTableId != other.propagationDefaultRouteTableId) return false
        if (transitGatewayCidrBlocks != other.transitGatewayCidrBlocks) return false
        if (vpnEcmpSupport != other.vpnEcmpSupport) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsEc2TransitGatewayDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A private Autonomous System Number (ASN) for the Amazon side of a BGP session.
         */
        public var amazonSideAsn: kotlin.Int = 0
        /**
         * The ID of the default association route table.
         */
        public var associationDefaultRouteTableId: kotlin.String? = null
        /**
         * Turn on or turn off automatic acceptance of attachment requests.
         */
        public var autoAcceptSharedAttachments: kotlin.String? = null
        /**
         * Turn on or turn off automatic association with the default association route table.
         */
        public var defaultRouteTableAssociation: kotlin.String? = null
        /**
         * Turn on or turn off automatic propagation of routes to the default propagation route table.
         */
        public var defaultRouteTablePropagation: kotlin.String? = null
        /**
         * The description of the transit gateway.
         */
        public var description: kotlin.String? = null
        /**
         * Turn on or turn off DNS support.
         */
        public var dnsSupport: kotlin.String? = null
        /**
         * The ID of the transit gateway.
         */
        public var id: kotlin.String? = null
        /**
         * Indicates whether multicast is supported on the transit gateway.
         */
        public var multicastSupport: kotlin.String? = null
        /**
         * The ID of the default propagation route table.
         */
        public var propagationDefaultRouteTableId: kotlin.String? = null
        /**
         * The transit gateway Classless Inter-Domain Routing (CIDR) blocks.
         */
        public var transitGatewayCidrBlocks: List<String>? = null
        /**
         * Turn on or turn off Equal Cost Multipath Protocol (ECMP) support.
         */
        public var vpnEcmpSupport: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsEc2TransitGatewayDetails) : this() {
            this.amazonSideAsn = x.amazonSideAsn
            this.associationDefaultRouteTableId = x.associationDefaultRouteTableId
            this.autoAcceptSharedAttachments = x.autoAcceptSharedAttachments
            this.defaultRouteTableAssociation = x.defaultRouteTableAssociation
            this.defaultRouteTablePropagation = x.defaultRouteTablePropagation
            this.description = x.description
            this.dnsSupport = x.dnsSupport
            this.id = x.id
            this.multicastSupport = x.multicastSupport
            this.propagationDefaultRouteTableId = x.propagationDefaultRouteTableId
            this.transitGatewayCidrBlocks = x.transitGatewayCidrBlocks
            this.vpnEcmpSupport = x.vpnEcmpSupport
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsEc2TransitGatewayDetails = AwsEc2TransitGatewayDetails(this)
    }
}
