// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Information about the server-side encryption for the table.
 */
public class AwsDynamoDbTableSseDescription private constructor(builder: Builder) {
    /**
     * If the key is inaccessible, the date and time when DynamoDB detected that the key was inaccessible.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val inaccessibleEncryptionDateTime: kotlin.String? = builder.inaccessibleEncryptionDateTime
    /**
     * The ARN of the KMS key that is used for the KMS encryption.
     */
    public val kmsMasterKeyArn: kotlin.String? = builder.kmsMasterKeyArn
    /**
     * The type of server-side encryption.
     */
    public val sseType: kotlin.String? = builder.sseType
    /**
     * The status of the server-side encryption.
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsDynamoDbTableSseDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsDynamoDbTableSseDescription(")
        append("inaccessibleEncryptionDateTime=$inaccessibleEncryptionDateTime,")
        append("kmsMasterKeyArn=$kmsMasterKeyArn,")
        append("sseType=$sseType,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = inaccessibleEncryptionDateTime?.hashCode() ?: 0
        result = 31 * result + (kmsMasterKeyArn?.hashCode() ?: 0)
        result = 31 * result + (sseType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsDynamoDbTableSseDescription

        if (inaccessibleEncryptionDateTime != other.inaccessibleEncryptionDateTime) return false
        if (kmsMasterKeyArn != other.kmsMasterKeyArn) return false
        if (sseType != other.sseType) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsDynamoDbTableSseDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * If the key is inaccessible, the date and time when DynamoDB detected that the key was inaccessible.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var inaccessibleEncryptionDateTime: kotlin.String? = null
        /**
         * The ARN of the KMS key that is used for the KMS encryption.
         */
        public var kmsMasterKeyArn: kotlin.String? = null
        /**
         * The type of server-side encryption.
         */
        public var sseType: kotlin.String? = null
        /**
         * The status of the server-side encryption.
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsDynamoDbTableSseDescription) : this() {
            this.inaccessibleEncryptionDateTime = x.inaccessibleEncryptionDateTime
            this.kmsMasterKeyArn = x.kmsMasterKeyArn
            this.sseType = x.sseType
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsDynamoDbTableSseDescription = AwsDynamoDbTableSseDescription(this)
    }
}
