// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Information about the build environment for this build project.
 */
public class AwsCodeBuildProjectEnvironment private constructor(builder: Builder) {
    /**
     * The certificate to use with this build project.
     */
    public val certificate: kotlin.String? = builder.certificate
    /**
     * A set of environment variables to make available to builds for the build project.
     */
    public val environmentVariables: List<AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails>? = builder.environmentVariables
    /**
     * The type of credentials CodeBuild uses to pull images in your build.
     *
     * Valid values:
     * + `CODEBUILD` specifies that CodeBuild uses its own credentials. This requires that you modify your ECR repository policy to trust the CodeBuild service principal.
     * + `SERVICE_ROLE` specifies that CodeBuild uses your build project's service role.
     *
     * When you use a cross-account or private registry image, you must use `SERVICE_ROLE` credentials. When you use an CodeBuild curated image, you must use `CODEBUILD` credentials.
     */
    public val imagePullCredentialsType: kotlin.String? = builder.imagePullCredentialsType
    /**
     * Whether to allow the Docker daemon to run inside a Docker container. Set to `true` if the build project is used to build Docker images.
     */
    public val privilegedMode: kotlin.Boolean = builder.privilegedMode
    /**
     * The credentials for access to a private registry.
     */
    public val registryCredential: aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectEnvironmentRegistryCredential? = builder.registryCredential
    /**
     * The type of build environment to use for related builds.
     *
     * The environment type `ARM_CONTAINER` is available only in Regions US East (N. Virginia), US East (Ohio), US West (Oregon), Europe (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Sydney), and Europe (Frankfurt).
     *
     * The environment type `LINUX_CONTAINER` with compute type build.general1.2xlarge is available only in Regions US East (N. Virginia), US East (N. Virginia), US West (Oregon), Canada (Central), Europe (Ireland), Europe (London), Europe (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore), Asia Pacific (Sydney), China (Beijing), and China (Ningxia).
     *
     * The environment type `LINUX_GPU_CONTAINER` is available only in Regions US East (N. Virginia), US East (N. Virginia), US West (Oregon), Canada (Central), Europe (Ireland), Europe (London), Europe (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore), Asia Pacific (Sydney), China (Beijing), and China (Ningxia).
     *
     * Valid values: `WINDOWS_CONTAINER` | `LINUX_CONTAINER` | `LINUX_GPU_CONTAINER` | `ARM_CONTAINER`
     */
    public val type: kotlin.String? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectEnvironment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsCodeBuildProjectEnvironment(")
        append("certificate=$certificate,")
        append("environmentVariables=$environmentVariables,")
        append("imagePullCredentialsType=$imagePullCredentialsType,")
        append("privilegedMode=$privilegedMode,")
        append("registryCredential=$registryCredential,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificate?.hashCode() ?: 0
        result = 31 * result + (environmentVariables?.hashCode() ?: 0)
        result = 31 * result + (imagePullCredentialsType?.hashCode() ?: 0)
        result = 31 * result + (privilegedMode.hashCode())
        result = 31 * result + (registryCredential?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsCodeBuildProjectEnvironment

        if (certificate != other.certificate) return false
        if (environmentVariables != other.environmentVariables) return false
        if (imagePullCredentialsType != other.imagePullCredentialsType) return false
        if (privilegedMode != other.privilegedMode) return false
        if (registryCredential != other.registryCredential) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectEnvironment = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The certificate to use with this build project.
         */
        public var certificate: kotlin.String? = null
        /**
         * A set of environment variables to make available to builds for the build project.
         */
        public var environmentVariables: List<AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails>? = null
        /**
         * The type of credentials CodeBuild uses to pull images in your build.
         *
         * Valid values:
         * + `CODEBUILD` specifies that CodeBuild uses its own credentials. This requires that you modify your ECR repository policy to trust the CodeBuild service principal.
         * + `SERVICE_ROLE` specifies that CodeBuild uses your build project's service role.
         *
         * When you use a cross-account or private registry image, you must use `SERVICE_ROLE` credentials. When you use an CodeBuild curated image, you must use `CODEBUILD` credentials.
         */
        public var imagePullCredentialsType: kotlin.String? = null
        /**
         * Whether to allow the Docker daemon to run inside a Docker container. Set to `true` if the build project is used to build Docker images.
         */
        public var privilegedMode: kotlin.Boolean = false
        /**
         * The credentials for access to a private registry.
         */
        public var registryCredential: aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectEnvironmentRegistryCredential? = null
        /**
         * The type of build environment to use for related builds.
         *
         * The environment type `ARM_CONTAINER` is available only in Regions US East (N. Virginia), US East (Ohio), US West (Oregon), Europe (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Sydney), and Europe (Frankfurt).
         *
         * The environment type `LINUX_CONTAINER` with compute type build.general1.2xlarge is available only in Regions US East (N. Virginia), US East (N. Virginia), US West (Oregon), Canada (Central), Europe (Ireland), Europe (London), Europe (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore), Asia Pacific (Sydney), China (Beijing), and China (Ningxia).
         *
         * The environment type `LINUX_GPU_CONTAINER` is available only in Regions US East (N. Virginia), US East (N. Virginia), US West (Oregon), Canada (Central), Europe (Ireland), Europe (London), Europe (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore), Asia Pacific (Sydney), China (Beijing), and China (Ningxia).
         *
         * Valid values: `WINDOWS_CONTAINER` | `LINUX_CONTAINER` | `LINUX_GPU_CONTAINER` | `ARM_CONTAINER`
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectEnvironment) : this() {
            this.certificate = x.certificate
            this.environmentVariables = x.environmentVariables
            this.imagePullCredentialsType = x.imagePullCredentialsType
            this.privilegedMode = x.privilegedMode
            this.registryCredential = x.registryCredential
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectEnvironment = AwsCodeBuildProjectEnvironment(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectEnvironmentRegistryCredential] inside the given [block]
         */
        public fun registryCredential(block: aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectEnvironmentRegistryCredential.Builder.() -> kotlin.Unit) {
            this.registryCredential = aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectEnvironmentRegistryCredential.invoke(block)
        }
    }
}
