// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Specifies the authorization configuration for using an OpenID Connect compliant service with your AppSync GraphQL API endpoint.
 */
public class AwsAppSyncGraphQlApiOpenIdConnectConfigDetails private constructor(builder: Builder) {
    /**
     * The number of milliseconds that a token is valid after being authenticated.
     */
    public val authTtl: kotlin.Long = builder.authTtl
    /**
     * The client identifier of the relying party at the OpenID identity provider. This identifier is typically obtained when the relying party is registered with the OpenID identity provider. You can specify a regular expression so that AppSync can validate against multiple client identifiers at a time.
     */
    public val clientId: kotlin.String? = builder.clientId
    /**
     * The number of milliseconds that a token is valid after it's issued to a user.
     */
    public val iatTtl: kotlin.Long = builder.iatTtl
    /**
     * The issuer for the OIDC configuration. The issuer returned by discovery must exactly match the value of `iss` in the ID token.
     */
    public val issuer: kotlin.String? = builder.issuer

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsAppSyncGraphQlApiOpenIdConnectConfigDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsAppSyncGraphQlApiOpenIdConnectConfigDetails(")
        append("authTtl=$authTtl,")
        append("clientId=$clientId,")
        append("iatTtl=$iatTtl,")
        append("issuer=$issuer")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authTtl.hashCode()
        result = 31 * result + (clientId?.hashCode() ?: 0)
        result = 31 * result + (iatTtl.hashCode())
        result = 31 * result + (issuer?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsAppSyncGraphQlApiOpenIdConnectConfigDetails

        if (authTtl != other.authTtl) return false
        if (clientId != other.clientId) return false
        if (iatTtl != other.iatTtl) return false
        if (issuer != other.issuer) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsAppSyncGraphQlApiOpenIdConnectConfigDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of milliseconds that a token is valid after being authenticated.
         */
        public var authTtl: kotlin.Long = 0L
        /**
         * The client identifier of the relying party at the OpenID identity provider. This identifier is typically obtained when the relying party is registered with the OpenID identity provider. You can specify a regular expression so that AppSync can validate against multiple client identifiers at a time.
         */
        public var clientId: kotlin.String? = null
        /**
         * The number of milliseconds that a token is valid after it's issued to a user.
         */
        public var iatTtl: kotlin.Long = 0L
        /**
         * The issuer for the OIDC configuration. The issuer returned by discovery must exactly match the value of `iss` in the ID token.
         */
        public var issuer: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsAppSyncGraphQlApiOpenIdConnectConfigDetails) : this() {
            this.authTtl = x.authTtl
            this.clientId = x.clientId
            this.iatTtl = x.iatTtl
            this.issuer = x.issuer
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsAppSyncGraphQlApiOpenIdConnectConfigDetails = AwsAppSyncGraphQlApiOpenIdConnectConfigDetails(this)
    }
}
