// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides information about a version 1 Amazon API Gateway stage.
 */
public class AwsApiGatewayStageDetails private constructor(builder: Builder) {
    /**
     * Settings for logging access for the stage.
     */
    public val accessLogSettings: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayAccessLogSettings? = builder.accessLogSettings
    /**
     * Indicates whether a cache cluster is enabled for the stage.
     */
    public val cacheClusterEnabled: kotlin.Boolean = builder.cacheClusterEnabled
    /**
     * If a cache cluster is enabled, the size of the cache cluster.
     */
    public val cacheClusterSize: kotlin.String? = builder.cacheClusterSize
    /**
     * If a cache cluster is enabled, the status of the cache cluster.
     */
    public val cacheClusterStatus: kotlin.String? = builder.cacheClusterStatus
    /**
     * Information about settings for canary deployment in the stage.
     */
    public val canarySettings: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayCanarySettings? = builder.canarySettings
    /**
     * The identifier of the client certificate for the stage.
     */
    public val clientCertificateId: kotlin.String? = builder.clientCertificateId
    /**
     * Indicates when the stage was created.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val createdDate: kotlin.String? = builder.createdDate
    /**
     * The identifier of the deployment that the stage points to.
     */
    public val deploymentId: kotlin.String? = builder.deploymentId
    /**
     * A description of the stage.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The version of the API documentation that is associated with the stage.
     */
    public val documentationVersion: kotlin.String? = builder.documentationVersion
    /**
     * Indicates when the stage was most recently updated.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val lastUpdatedDate: kotlin.String? = builder.lastUpdatedDate
    /**
     * Defines the method settings for the stage.
     */
    public val methodSettings: List<AwsApiGatewayMethodSettings>? = builder.methodSettings
    /**
     * The name of the stage.
     */
    public val stageName: kotlin.String? = builder.stageName
    /**
     * Indicates whether active tracing with X-Ray is enabled for the stage.
     */
    public val tracingEnabled: kotlin.Boolean = builder.tracingEnabled
    /**
     * A map that defines the stage variables for the stage.
     *
     * Variable names can have alphanumeric and underscore characters.
     *
     * Variable values can contain the following characters:
     * + Uppercase and lowercase letters
     * + Numbers
     * + Special characters -._~:/?#&=,
     */
    public val variables: Map<String, String>? = builder.variables
    /**
     * The ARN of the web ACL associated with the stage.
     */
    public val webAclArn: kotlin.String? = builder.webAclArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayStageDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsApiGatewayStageDetails(")
        append("accessLogSettings=$accessLogSettings,")
        append("cacheClusterEnabled=$cacheClusterEnabled,")
        append("cacheClusterSize=$cacheClusterSize,")
        append("cacheClusterStatus=$cacheClusterStatus,")
        append("canarySettings=$canarySettings,")
        append("clientCertificateId=$clientCertificateId,")
        append("createdDate=$createdDate,")
        append("deploymentId=$deploymentId,")
        append("description=$description,")
        append("documentationVersion=$documentationVersion,")
        append("lastUpdatedDate=$lastUpdatedDate,")
        append("methodSettings=$methodSettings,")
        append("stageName=$stageName,")
        append("tracingEnabled=$tracingEnabled,")
        append("variables=$variables,")
        append("webAclArn=$webAclArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessLogSettings?.hashCode() ?: 0
        result = 31 * result + (cacheClusterEnabled.hashCode())
        result = 31 * result + (cacheClusterSize?.hashCode() ?: 0)
        result = 31 * result + (cacheClusterStatus?.hashCode() ?: 0)
        result = 31 * result + (canarySettings?.hashCode() ?: 0)
        result = 31 * result + (clientCertificateId?.hashCode() ?: 0)
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (deploymentId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (documentationVersion?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDate?.hashCode() ?: 0)
        result = 31 * result + (methodSettings?.hashCode() ?: 0)
        result = 31 * result + (stageName?.hashCode() ?: 0)
        result = 31 * result + (tracingEnabled.hashCode())
        result = 31 * result + (variables?.hashCode() ?: 0)
        result = 31 * result + (webAclArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsApiGatewayStageDetails

        if (accessLogSettings != other.accessLogSettings) return false
        if (cacheClusterEnabled != other.cacheClusterEnabled) return false
        if (cacheClusterSize != other.cacheClusterSize) return false
        if (cacheClusterStatus != other.cacheClusterStatus) return false
        if (canarySettings != other.canarySettings) return false
        if (clientCertificateId != other.clientCertificateId) return false
        if (createdDate != other.createdDate) return false
        if (deploymentId != other.deploymentId) return false
        if (description != other.description) return false
        if (documentationVersion != other.documentationVersion) return false
        if (lastUpdatedDate != other.lastUpdatedDate) return false
        if (methodSettings != other.methodSettings) return false
        if (stageName != other.stageName) return false
        if (tracingEnabled != other.tracingEnabled) return false
        if (variables != other.variables) return false
        if (webAclArn != other.webAclArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayStageDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Settings for logging access for the stage.
         */
        public var accessLogSettings: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayAccessLogSettings? = null
        /**
         * Indicates whether a cache cluster is enabled for the stage.
         */
        public var cacheClusterEnabled: kotlin.Boolean = false
        /**
         * If a cache cluster is enabled, the size of the cache cluster.
         */
        public var cacheClusterSize: kotlin.String? = null
        /**
         * If a cache cluster is enabled, the status of the cache cluster.
         */
        public var cacheClusterStatus: kotlin.String? = null
        /**
         * Information about settings for canary deployment in the stage.
         */
        public var canarySettings: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayCanarySettings? = null
        /**
         * The identifier of the client certificate for the stage.
         */
        public var clientCertificateId: kotlin.String? = null
        /**
         * Indicates when the stage was created.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var createdDate: kotlin.String? = null
        /**
         * The identifier of the deployment that the stage points to.
         */
        public var deploymentId: kotlin.String? = null
        /**
         * A description of the stage.
         */
        public var description: kotlin.String? = null
        /**
         * The version of the API documentation that is associated with the stage.
         */
        public var documentationVersion: kotlin.String? = null
        /**
         * Indicates when the stage was most recently updated.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var lastUpdatedDate: kotlin.String? = null
        /**
         * Defines the method settings for the stage.
         */
        public var methodSettings: List<AwsApiGatewayMethodSettings>? = null
        /**
         * The name of the stage.
         */
        public var stageName: kotlin.String? = null
        /**
         * Indicates whether active tracing with X-Ray is enabled for the stage.
         */
        public var tracingEnabled: kotlin.Boolean = false
        /**
         * A map that defines the stage variables for the stage.
         *
         * Variable names can have alphanumeric and underscore characters.
         *
         * Variable values can contain the following characters:
         * + Uppercase and lowercase letters
         * + Numbers
         * + Special characters -._~:/?#&=,
         */
        public var variables: Map<String, String>? = null
        /**
         * The ARN of the web ACL associated with the stage.
         */
        public var webAclArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayStageDetails) : this() {
            this.accessLogSettings = x.accessLogSettings
            this.cacheClusterEnabled = x.cacheClusterEnabled
            this.cacheClusterSize = x.cacheClusterSize
            this.cacheClusterStatus = x.cacheClusterStatus
            this.canarySettings = x.canarySettings
            this.clientCertificateId = x.clientCertificateId
            this.createdDate = x.createdDate
            this.deploymentId = x.deploymentId
            this.description = x.description
            this.documentationVersion = x.documentationVersion
            this.lastUpdatedDate = x.lastUpdatedDate
            this.methodSettings = x.methodSettings
            this.stageName = x.stageName
            this.tracingEnabled = x.tracingEnabled
            this.variables = x.variables
            this.webAclArn = x.webAclArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayStageDetails = AwsApiGatewayStageDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayAccessLogSettings] inside the given [block]
         */
        public fun accessLogSettings(block: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayAccessLogSettings.Builder.() -> kotlin.Unit) {
            this.accessLogSettings = aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayAccessLogSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayCanarySettings] inside the given [block]
         */
        public fun canarySettings(block: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayCanarySettings.Builder.() -> kotlin.Unit) {
            this.canarySettings = aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayCanarySettings.invoke(block)
        }
    }
}
