// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Metadata for automation rules in the calling account. The response includes rules with a `RuleStatus` of `ENABLED` and `DISABLED`.
 */
public class AutomationRulesMetadata private constructor(builder: Builder) {
    /**
     * A timestamp that indicates when the rule was created.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The principal that created a rule.
     */
    public val createdBy: kotlin.String? = builder.createdBy
    /**
     * A description of the rule.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Specifies whether a rule is the last to be applied with respect to a finding that matches the rule criteria. This is useful when a finding matches the criteria for multiple rules, and each rule has different actions. If the value of this field is set to `true` for a rule, Security Hub applies the rule action to a finding that matches the rule criteria and won't evaluate other rules for the finding.  The default value of this field is `false`.
     */
    public val isTerminal: kotlin.Boolean = builder.isTerminal
    /**
     * The Amazon Resource Name (ARN) for the rule.
     */
    public val ruleArn: kotlin.String? = builder.ruleArn
    /**
     * The name of the rule.
     */
    public val ruleName: kotlin.String? = builder.ruleName
    /**
     * An integer ranging from 1 to 1000 that represents the order in which the rule action is applied to findings. Security Hub applies rules with lower values for this parameter first.
     */
    public val ruleOrder: kotlin.Int = builder.ruleOrder
    /**
     * Whether the rule is active after it is created. If this parameter is equal to `ENABLED`, Security Hub will apply the rule to findings and finding updates after the rule is created. To change the value of this parameter after creating a rule, use `BatchUpdateAutomationRules`.
     */
    public val ruleStatus: aws.sdk.kotlin.services.securityhub.model.RuleStatus? = builder.ruleStatus
    /**
     * A timestamp that indicates when the rule was most recently updated.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AutomationRulesMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutomationRulesMetadata(")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("description=$description,")
        append("isTerminal=$isTerminal,")
        append("ruleArn=$ruleArn,")
        append("ruleName=$ruleName,")
        append("ruleOrder=$ruleOrder,")
        append("ruleStatus=$ruleStatus,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (isTerminal.hashCode())
        result = 31 * result + (ruleArn?.hashCode() ?: 0)
        result = 31 * result + (ruleName?.hashCode() ?: 0)
        result = 31 * result + (ruleOrder)
        result = 31 * result + (ruleStatus?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutomationRulesMetadata

        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (description != other.description) return false
        if (isTerminal != other.isTerminal) return false
        if (ruleArn != other.ruleArn) return false
        if (ruleName != other.ruleName) return false
        if (ruleOrder != other.ruleOrder) return false
        if (ruleStatus != other.ruleStatus) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AutomationRulesMetadata = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A timestamp that indicates when the rule was created.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The principal that created a rule.
         */
        public var createdBy: kotlin.String? = null
        /**
         * A description of the rule.
         */
        public var description: kotlin.String? = null
        /**
         * Specifies whether a rule is the last to be applied with respect to a finding that matches the rule criteria. This is useful when a finding matches the criteria for multiple rules, and each rule has different actions. If the value of this field is set to `true` for a rule, Security Hub applies the rule action to a finding that matches the rule criteria and won't evaluate other rules for the finding.  The default value of this field is `false`.
         */
        public var isTerminal: kotlin.Boolean = false
        /**
         * The Amazon Resource Name (ARN) for the rule.
         */
        public var ruleArn: kotlin.String? = null
        /**
         * The name of the rule.
         */
        public var ruleName: kotlin.String? = null
        /**
         * An integer ranging from 1 to 1000 that represents the order in which the rule action is applied to findings. Security Hub applies rules with lower values for this parameter first.
         */
        public var ruleOrder: kotlin.Int = 0
        /**
         * Whether the rule is active after it is created. If this parameter is equal to `ENABLED`, Security Hub will apply the rule to findings and finding updates after the rule is created. To change the value of this parameter after creating a rule, use `BatchUpdateAutomationRules`.
         */
        public var ruleStatus: aws.sdk.kotlin.services.securityhub.model.RuleStatus? = null
        /**
         * A timestamp that indicates when the rule was most recently updated.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AutomationRulesMetadata) : this() {
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.description = x.description
            this.isTerminal = x.isTerminal
            this.ruleArn = x.ruleArn
            this.ruleName = x.ruleName
            this.ruleOrder = x.ruleOrder
            this.ruleStatus = x.ruleStatus
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AutomationRulesMetadata = AutomationRulesMetadata(this)
    }
}
