// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.serde

import aws.sdk.kotlin.services.securityhub.model.CreateFindingAggregatorResponse
import aws.sdk.kotlin.services.securityhub.model.SecurityHubException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class CreateFindingAggregatorOperationDeserializer: HttpDeserialize<CreateFindingAggregatorResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateFindingAggregatorResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateFindingAggregatorError(context, call)
        }
        val builder = CreateFindingAggregatorResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateFindingAggregatorOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateFindingAggregatorError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SecurityHubException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidAccessException" -> InvalidAccessExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SecurityHubException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateFindingAggregatorOperationBody(builder: CreateFindingAggregatorResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FINDINGAGGREGATIONREGION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FindingAggregationRegion"))
    val FINDINGAGGREGATORARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FindingAggregatorArn"))
    val REGIONLINKINGMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RegionLinkingMode"))
    val REGIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Regions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FINDINGAGGREGATIONREGION_DESCRIPTOR)
        field(FINDINGAGGREGATORARN_DESCRIPTOR)
        field(REGIONLINKINGMODE_DESCRIPTOR)
        field(REGIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FINDINGAGGREGATIONREGION_DESCRIPTOR.index -> builder.findingAggregationRegion = deserializeString()
                FINDINGAGGREGATORARN_DESCRIPTOR.index -> builder.findingAggregatorArn = deserializeString()
                REGIONLINKINGMODE_DESCRIPTOR.index -> builder.regionLinkingMode = deserializeString()
                REGIONS_DESCRIPTOR.index -> builder.regions =
                    deserializer.deserializeList(REGIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
