// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.paginators

import aws.sdk.kotlin.services.securityhub.SecurityHubClient
import aws.sdk.kotlin.services.securityhub.model.ActionTarget
import aws.sdk.kotlin.services.securityhub.model.AdminAccount
import aws.sdk.kotlin.services.securityhub.model.AwsSecurityFinding
import aws.sdk.kotlin.services.securityhub.model.DescribeActionTargetsRequest
import aws.sdk.kotlin.services.securityhub.model.DescribeActionTargetsResponse
import aws.sdk.kotlin.services.securityhub.model.DescribeProductsRequest
import aws.sdk.kotlin.services.securityhub.model.DescribeProductsResponse
import aws.sdk.kotlin.services.securityhub.model.DescribeStandardsControlsRequest
import aws.sdk.kotlin.services.securityhub.model.DescribeStandardsControlsResponse
import aws.sdk.kotlin.services.securityhub.model.DescribeStandardsRequest
import aws.sdk.kotlin.services.securityhub.model.DescribeStandardsResponse
import aws.sdk.kotlin.services.securityhub.model.FindingAggregator
import aws.sdk.kotlin.services.securityhub.model.FindingHistoryRecord
import aws.sdk.kotlin.services.securityhub.model.GetEnabledStandardsRequest
import aws.sdk.kotlin.services.securityhub.model.GetEnabledStandardsResponse
import aws.sdk.kotlin.services.securityhub.model.GetFindingHistoryRequest
import aws.sdk.kotlin.services.securityhub.model.GetFindingHistoryResponse
import aws.sdk.kotlin.services.securityhub.model.GetFindingsRequest
import aws.sdk.kotlin.services.securityhub.model.GetFindingsResponse
import aws.sdk.kotlin.services.securityhub.model.GetInsightsRequest
import aws.sdk.kotlin.services.securityhub.model.GetInsightsResponse
import aws.sdk.kotlin.services.securityhub.model.Insight
import aws.sdk.kotlin.services.securityhub.model.Invitation
import aws.sdk.kotlin.services.securityhub.model.ListEnabledProductsForImportRequest
import aws.sdk.kotlin.services.securityhub.model.ListEnabledProductsForImportResponse
import aws.sdk.kotlin.services.securityhub.model.ListFindingAggregatorsRequest
import aws.sdk.kotlin.services.securityhub.model.ListFindingAggregatorsResponse
import aws.sdk.kotlin.services.securityhub.model.ListInvitationsRequest
import aws.sdk.kotlin.services.securityhub.model.ListInvitationsResponse
import aws.sdk.kotlin.services.securityhub.model.ListMembersRequest
import aws.sdk.kotlin.services.securityhub.model.ListMembersResponse
import aws.sdk.kotlin.services.securityhub.model.ListOrganizationAdminAccountsRequest
import aws.sdk.kotlin.services.securityhub.model.ListOrganizationAdminAccountsResponse
import aws.sdk.kotlin.services.securityhub.model.ListSecurityControlDefinitionsRequest
import aws.sdk.kotlin.services.securityhub.model.ListSecurityControlDefinitionsResponse
import aws.sdk.kotlin.services.securityhub.model.ListStandardsControlAssociationsRequest
import aws.sdk.kotlin.services.securityhub.model.ListStandardsControlAssociationsResponse
import aws.sdk.kotlin.services.securityhub.model.Member
import aws.sdk.kotlin.services.securityhub.model.Product
import aws.sdk.kotlin.services.securityhub.model.SecurityControlDefinition
import aws.sdk.kotlin.services.securityhub.model.Standard
import aws.sdk.kotlin.services.securityhub.model.StandardsControl
import aws.sdk.kotlin.services.securityhub.model.StandardsControlAssociationSummary
import aws.sdk.kotlin.services.securityhub.model.StandardsSubscription
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeActionTargetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeActionTargetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeActionTargetsResponse]
 */
public fun SecurityHubClient.describeActionTargetsPaginated(initialRequest: DescribeActionTargetsRequest = DescribeActionTargetsRequest { }): Flow<DescribeActionTargetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeActionTargetsPaginated.describeActionTargets(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeActionTargetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeActionTargetsResponse]
 */
public fun SecurityHubClient.describeActionTargetsPaginated(block: DescribeActionTargetsRequest.Builder.() -> Unit): Flow<DescribeActionTargetsResponse> =
    describeActionTargetsPaginated(DescribeActionTargetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeActionTargetsPaginated]
 * to access the nested member [ActionTarget]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ActionTarget]
 */
@JvmName("describeActionTargetsResponseActionTarget")
public fun Flow<DescribeActionTargetsResponse>.actionTargets(): Flow<ActionTarget> =
    transform() { response ->
        response.actionTargets?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeProductsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeProductsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeProductsResponse]
 */
public fun SecurityHubClient.describeProductsPaginated(initialRequest: DescribeProductsRequest = DescribeProductsRequest { }): Flow<DescribeProductsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeProductsPaginated.describeProducts(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeProductsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeProductsResponse]
 */
public fun SecurityHubClient.describeProductsPaginated(block: DescribeProductsRequest.Builder.() -> Unit): Flow<DescribeProductsResponse> =
    describeProductsPaginated(DescribeProductsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeProductsPaginated]
 * to access the nested member [Product]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Product]
 */
@JvmName("describeProductsResponseProduct")
public fun Flow<DescribeProductsResponse>.products(): Flow<Product> =
    transform() { response ->
        response.products?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeStandardsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeStandardsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeStandardsResponse]
 */
public fun SecurityHubClient.describeStandardsPaginated(initialRequest: DescribeStandardsRequest = DescribeStandardsRequest { }): Flow<DescribeStandardsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeStandardsPaginated.describeStandards(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeStandardsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeStandardsResponse]
 */
public fun SecurityHubClient.describeStandardsPaginated(block: DescribeStandardsRequest.Builder.() -> Unit): Flow<DescribeStandardsResponse> =
    describeStandardsPaginated(DescribeStandardsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeStandardsPaginated]
 * to access the nested member [Standard]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Standard]
 */
@JvmName("describeStandardsResponseStandard")
public fun Flow<DescribeStandardsResponse>.standards(): Flow<Standard> =
    transform() { response ->
        response.standards?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeStandardsControlsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeStandardsControlsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeStandardsControlsResponse]
 */
public fun SecurityHubClient.describeStandardsControlsPaginated(initialRequest: DescribeStandardsControlsRequest): Flow<DescribeStandardsControlsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeStandardsControlsPaginated.describeStandardsControls(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeStandardsControlsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeStandardsControlsResponse]
 */
public fun SecurityHubClient.describeStandardsControlsPaginated(block: DescribeStandardsControlsRequest.Builder.() -> Unit): Flow<DescribeStandardsControlsResponse> =
    describeStandardsControlsPaginated(DescribeStandardsControlsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeStandardsControlsPaginated]
 * to access the nested member [StandardsControl]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StandardsControl]
 */
@JvmName("describeStandardsControlsResponseStandardsControl")
public fun Flow<DescribeStandardsControlsResponse>.controls(): Flow<StandardsControl> =
    transform() { response ->
        response.controls?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetEnabledStandardsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetEnabledStandardsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetEnabledStandardsResponse]
 */
public fun SecurityHubClient.getEnabledStandardsPaginated(initialRequest: GetEnabledStandardsRequest = GetEnabledStandardsRequest { }): Flow<GetEnabledStandardsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getEnabledStandardsPaginated.getEnabledStandards(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetEnabledStandardsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetEnabledStandardsResponse]
 */
public fun SecurityHubClient.getEnabledStandardsPaginated(block: GetEnabledStandardsRequest.Builder.() -> Unit): Flow<GetEnabledStandardsResponse> =
    getEnabledStandardsPaginated(GetEnabledStandardsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getEnabledStandardsPaginated]
 * to access the nested member [StandardsSubscription]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StandardsSubscription]
 */
@JvmName("getEnabledStandardsResponseStandardsSubscription")
public fun Flow<GetEnabledStandardsResponse>.standardsSubscriptions(): Flow<StandardsSubscription> =
    transform() { response ->
        response.standardsSubscriptions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetFindingHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetFindingHistoryRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetFindingHistoryResponse]
 */
public fun SecurityHubClient.getFindingHistoryPaginated(initialRequest: GetFindingHistoryRequest): Flow<GetFindingHistoryResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getFindingHistoryPaginated.getFindingHistory(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetFindingHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetFindingHistoryResponse]
 */
public fun SecurityHubClient.getFindingHistoryPaginated(block: GetFindingHistoryRequest.Builder.() -> Unit): Flow<GetFindingHistoryResponse> =
    getFindingHistoryPaginated(GetFindingHistoryRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getFindingHistoryPaginated]
 * to access the nested member [FindingHistoryRecord]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FindingHistoryRecord]
 */
@JvmName("getFindingHistoryResponseFindingHistoryRecord")
public fun Flow<GetFindingHistoryResponse>.records(): Flow<FindingHistoryRecord> =
    transform() { response ->
        response.records?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetFindingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetFindingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetFindingsResponse]
 */
public fun SecurityHubClient.getFindingsPaginated(initialRequest: GetFindingsRequest = GetFindingsRequest { }): Flow<GetFindingsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getFindingsPaginated.getFindings(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetFindingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetFindingsResponse]
 */
public fun SecurityHubClient.getFindingsPaginated(block: GetFindingsRequest.Builder.() -> Unit): Flow<GetFindingsResponse> =
    getFindingsPaginated(GetFindingsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getFindingsPaginated]
 * to access the nested member [AwsSecurityFinding]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AwsSecurityFinding]
 */
@JvmName("getFindingsResponseAwsSecurityFinding")
public fun Flow<GetFindingsResponse>.findings(): Flow<AwsSecurityFinding> =
    transform() { response ->
        response.findings?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetInsightsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetInsightsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetInsightsResponse]
 */
public fun SecurityHubClient.getInsightsPaginated(initialRequest: GetInsightsRequest = GetInsightsRequest { }): Flow<GetInsightsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getInsightsPaginated.getInsights(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetInsightsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetInsightsResponse]
 */
public fun SecurityHubClient.getInsightsPaginated(block: GetInsightsRequest.Builder.() -> Unit): Flow<GetInsightsResponse> =
    getInsightsPaginated(GetInsightsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getInsightsPaginated]
 * to access the nested member [Insight]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Insight]
 */
@JvmName("getInsightsResponseInsight")
public fun Flow<GetInsightsResponse>.insights(): Flow<Insight> =
    transform() { response ->
        response.insights?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListEnabledProductsForImportResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEnabledProductsForImportRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEnabledProductsForImportResponse]
 */
public fun SecurityHubClient.listEnabledProductsForImportPaginated(initialRequest: ListEnabledProductsForImportRequest = ListEnabledProductsForImportRequest { }): Flow<ListEnabledProductsForImportResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEnabledProductsForImportPaginated.listEnabledProductsForImport(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEnabledProductsForImportResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEnabledProductsForImportResponse]
 */
public fun SecurityHubClient.listEnabledProductsForImportPaginated(block: ListEnabledProductsForImportRequest.Builder.() -> Unit): Flow<ListEnabledProductsForImportResponse> =
    listEnabledProductsForImportPaginated(ListEnabledProductsForImportRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEnabledProductsForImportPaginated]
 * to access the nested member [NonEmptyString]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [NonEmptyString]
 */
@JvmName("listEnabledProductsForImportResponseNonEmptyString")
public fun Flow<ListEnabledProductsForImportResponse>.productSubscriptions(): Flow<String> =
    transform() { response ->
        response.productSubscriptions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFindingAggregatorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFindingAggregatorsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFindingAggregatorsResponse]
 */
public fun SecurityHubClient.listFindingAggregatorsPaginated(initialRequest: ListFindingAggregatorsRequest = ListFindingAggregatorsRequest { }): Flow<ListFindingAggregatorsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFindingAggregatorsPaginated.listFindingAggregators(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListFindingAggregatorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFindingAggregatorsResponse]
 */
public fun SecurityHubClient.listFindingAggregatorsPaginated(block: ListFindingAggregatorsRequest.Builder.() -> Unit): Flow<ListFindingAggregatorsResponse> =
    listFindingAggregatorsPaginated(ListFindingAggregatorsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFindingAggregatorsPaginated]
 * to access the nested member [FindingAggregator]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FindingAggregator]
 */
@JvmName("listFindingAggregatorsResponseFindingAggregator")
public fun Flow<ListFindingAggregatorsResponse>.findingAggregators(): Flow<FindingAggregator> =
    transform() { response ->
        response.findingAggregators?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListInvitationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListInvitationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInvitationsResponse]
 */
public fun SecurityHubClient.listInvitationsPaginated(initialRequest: ListInvitationsRequest = ListInvitationsRequest { }): Flow<ListInvitationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listInvitationsPaginated.listInvitations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListInvitationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInvitationsResponse]
 */
public fun SecurityHubClient.listInvitationsPaginated(block: ListInvitationsRequest.Builder.() -> Unit): Flow<ListInvitationsResponse> =
    listInvitationsPaginated(ListInvitationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listInvitationsPaginated]
 * to access the nested member [Invitation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Invitation]
 */
@JvmName("listInvitationsResponseInvitation")
public fun Flow<ListInvitationsResponse>.invitations(): Flow<Invitation> =
    transform() { response ->
        response.invitations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListMembersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMembersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMembersResponse]
 */
public fun SecurityHubClient.listMembersPaginated(initialRequest: ListMembersRequest = ListMembersRequest { }): Flow<ListMembersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMembersPaginated.listMembers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListMembersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMembersResponse]
 */
public fun SecurityHubClient.listMembersPaginated(block: ListMembersRequest.Builder.() -> Unit): Flow<ListMembersResponse> =
    listMembersPaginated(ListMembersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listMembersPaginated]
 * to access the nested member [Member]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Member]
 */
@JvmName("listMembersResponseMember")
public fun Flow<ListMembersResponse>.members(): Flow<Member> =
    transform() { response ->
        response.members?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListOrganizationAdminAccountsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListOrganizationAdminAccountsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOrganizationAdminAccountsResponse]
 */
public fun SecurityHubClient.listOrganizationAdminAccountsPaginated(initialRequest: ListOrganizationAdminAccountsRequest = ListOrganizationAdminAccountsRequest { }): Flow<ListOrganizationAdminAccountsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listOrganizationAdminAccountsPaginated.listOrganizationAdminAccounts(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListOrganizationAdminAccountsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOrganizationAdminAccountsResponse]
 */
public fun SecurityHubClient.listOrganizationAdminAccountsPaginated(block: ListOrganizationAdminAccountsRequest.Builder.() -> Unit): Flow<ListOrganizationAdminAccountsResponse> =
    listOrganizationAdminAccountsPaginated(ListOrganizationAdminAccountsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listOrganizationAdminAccountsPaginated]
 * to access the nested member [AdminAccount]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AdminAccount]
 */
@JvmName("listOrganizationAdminAccountsResponseAdminAccount")
public fun Flow<ListOrganizationAdminAccountsResponse>.adminAccounts(): Flow<AdminAccount> =
    transform() { response ->
        response.adminAccounts?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSecurityControlDefinitionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSecurityControlDefinitionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSecurityControlDefinitionsResponse]
 */
public fun SecurityHubClient.listSecurityControlDefinitionsPaginated(initialRequest: ListSecurityControlDefinitionsRequest = ListSecurityControlDefinitionsRequest { }): Flow<ListSecurityControlDefinitionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSecurityControlDefinitionsPaginated.listSecurityControlDefinitions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSecurityControlDefinitionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSecurityControlDefinitionsResponse]
 */
public fun SecurityHubClient.listSecurityControlDefinitionsPaginated(block: ListSecurityControlDefinitionsRequest.Builder.() -> Unit): Flow<ListSecurityControlDefinitionsResponse> =
    listSecurityControlDefinitionsPaginated(ListSecurityControlDefinitionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSecurityControlDefinitionsPaginated]
 * to access the nested member [SecurityControlDefinition]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SecurityControlDefinition]
 */
@JvmName("listSecurityControlDefinitionsResponseSecurityControlDefinition")
public fun Flow<ListSecurityControlDefinitionsResponse>.securityControlDefinitions(): Flow<SecurityControlDefinition> =
    transform() { response ->
        response.securityControlDefinitions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListStandardsControlAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStandardsControlAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStandardsControlAssociationsResponse]
 */
public fun SecurityHubClient.listStandardsControlAssociationsPaginated(initialRequest: ListStandardsControlAssociationsRequest): Flow<ListStandardsControlAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStandardsControlAssociationsPaginated.listStandardsControlAssociations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListStandardsControlAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStandardsControlAssociationsResponse]
 */
public fun SecurityHubClient.listStandardsControlAssociationsPaginated(block: ListStandardsControlAssociationsRequest.Builder.() -> Unit): Flow<ListStandardsControlAssociationsResponse> =
    listStandardsControlAssociationsPaginated(ListStandardsControlAssociationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listStandardsControlAssociationsPaginated]
 * to access the nested member [StandardsControlAssociationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StandardsControlAssociationSummary]
 */
@JvmName("listStandardsControlAssociationsResponseStandardsControlAssociationSummary")
public fun Flow<ListStandardsControlAssociationsResponse>.standardsControlAssociationSummaries(): Flow<StandardsControlAssociationSummary> =
    transform() { response ->
        response.standardsControlAssociationSummaries?.forEach {
            emit(it)
        }
    }
