// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Specifies the parameters to update in an existing automation rule.
 */
public class UpdateAutomationRulesRequestItem private constructor(builder: Builder) {
    /**
     * One or more actions to update finding fields if a finding matches the conditions specified in `Criteria`.
     */
    public val actions: List<AutomationRulesAction>? = builder.actions
    /**
     * A set of ASFF finding field attributes and corresponding expected values that Security Hub uses to filter findings. If a rule is enabled and a finding matches the conditions specified in this parameter, Security Hub applies the rule action to the finding.
     */
    public val criteria: aws.sdk.kotlin.services.securityhub.model.AutomationRulesFindingFilters? = builder.criteria
    /**
     * A description of the rule.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Specifies whether a rule is the last to be applied with respect to a finding that matches the rule criteria. This is useful when a finding matches the criteria for multiple rules, and each rule has different actions. If a rule is terminal, Security Hub applies the rule action to a finding that matches the rule criteria and doesn't evaluate other rules for the finding. By default, a rule isn't terminal.
     */
    public val isTerminal: kotlin.Boolean? = builder.isTerminal
    /**
     * The Amazon Resource Name (ARN) for the rule.
     */
    public val ruleArn: kotlin.String? = builder.ruleArn
    /**
     * The name of the rule.
     */
    public val ruleName: kotlin.String? = builder.ruleName
    /**
     * An integer ranging from 1 to 1000 that represents the order in which the rule action is applied to findings. Security Hub applies rules with lower values for this parameter first.
     */
    public val ruleOrder: kotlin.Int? = builder.ruleOrder
    /**
     * Whether the rule is active after it is created. If this parameter is equal to `ENABLED`, Security Hub starts applying the rule to findings and finding updates after the rule is created. To change the value of this parameter after creating a rule, use `BatchUpdateAutomationRules`[](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateAutomationRules.html).
     */
    public val ruleStatus: aws.sdk.kotlin.services.securityhub.model.RuleStatus? = builder.ruleStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.UpdateAutomationRulesRequestItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateAutomationRulesRequestItem(")
        append("actions=$actions,")
        append("criteria=$criteria,")
        append("description=$description,")
        append("isTerminal=$isTerminal,")
        append("ruleArn=$ruleArn,")
        append("ruleName=$ruleName,")
        append("ruleOrder=$ruleOrder,")
        append("ruleStatus=$ruleStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (criteria?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (isTerminal?.hashCode() ?: 0)
        result = 31 * result + (ruleArn?.hashCode() ?: 0)
        result = 31 * result + (ruleName?.hashCode() ?: 0)
        result = 31 * result + (ruleOrder ?: 0)
        result = 31 * result + (ruleStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateAutomationRulesRequestItem

        if (actions != other.actions) return false
        if (criteria != other.criteria) return false
        if (description != other.description) return false
        if (isTerminal != other.isTerminal) return false
        if (ruleArn != other.ruleArn) return false
        if (ruleName != other.ruleName) return false
        if (ruleOrder != other.ruleOrder) return false
        if (ruleStatus != other.ruleStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.UpdateAutomationRulesRequestItem = Builder(this).apply(block).build()

    public class Builder {
        /**
         * One or more actions to update finding fields if a finding matches the conditions specified in `Criteria`.
         */
        public var actions: List<AutomationRulesAction>? = null
        /**
         * A set of ASFF finding field attributes and corresponding expected values that Security Hub uses to filter findings. If a rule is enabled and a finding matches the conditions specified in this parameter, Security Hub applies the rule action to the finding.
         */
        public var criteria: aws.sdk.kotlin.services.securityhub.model.AutomationRulesFindingFilters? = null
        /**
         * A description of the rule.
         */
        public var description: kotlin.String? = null
        /**
         * Specifies whether a rule is the last to be applied with respect to a finding that matches the rule criteria. This is useful when a finding matches the criteria for multiple rules, and each rule has different actions. If a rule is terminal, Security Hub applies the rule action to a finding that matches the rule criteria and doesn't evaluate other rules for the finding. By default, a rule isn't terminal.
         */
        public var isTerminal: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) for the rule.
         */
        public var ruleArn: kotlin.String? = null
        /**
         * The name of the rule.
         */
        public var ruleName: kotlin.String? = null
        /**
         * An integer ranging from 1 to 1000 that represents the order in which the rule action is applied to findings. Security Hub applies rules with lower values for this parameter first.
         */
        public var ruleOrder: kotlin.Int? = null
        /**
         * Whether the rule is active after it is created. If this parameter is equal to `ENABLED`, Security Hub starts applying the rule to findings and finding updates after the rule is created. To change the value of this parameter after creating a rule, use `BatchUpdateAutomationRules`[](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateAutomationRules.html).
         */
        public var ruleStatus: aws.sdk.kotlin.services.securityhub.model.RuleStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.UpdateAutomationRulesRequestItem) : this() {
            this.actions = x.actions
            this.criteria = x.criteria
            this.description = x.description
            this.isTerminal = x.isTerminal
            this.ruleArn = x.ruleArn
            this.ruleName = x.ruleName
            this.ruleOrder = x.ruleOrder
            this.ruleStatus = x.ruleStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.UpdateAutomationRulesRequestItem = UpdateAutomationRulesRequestItem(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AutomationRulesFindingFilters] inside the given [block]
         */
        public fun criteria(block: aws.sdk.kotlin.services.securityhub.model.AutomationRulesFindingFilters.Builder.() -> kotlin.Unit) {
            this.criteria = aws.sdk.kotlin.services.securityhub.model.AutomationRulesFindingFilters.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
