// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Details about the threat intelligence related to a finding.
 */
public class ThreatIntelIndicator private constructor(builder: Builder) {
    /**
     * The category of a threat intelligence indicator.
     */
    public val category: aws.sdk.kotlin.services.securityhub.model.ThreatIntelIndicatorCategory? = builder.category
    /**
     * Indicates when the most recent instance of a threat intelligence indicator was observed.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val lastObservedAt: kotlin.String? = builder.lastObservedAt
    /**
     * The source of the threat intelligence indicator.
     */
    public val source: kotlin.String? = builder.source
    /**
     * The URL to the page or site where you can get more information about the threat intelligence indicator.
     */
    public val sourceUrl: kotlin.String? = builder.sourceUrl
    /**
     * The type of threat intelligence indicator.
     */
    public val type: aws.sdk.kotlin.services.securityhub.model.ThreatIntelIndicatorType? = builder.type
    /**
     * The value of a threat intelligence indicator.
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.ThreatIntelIndicator = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ThreatIntelIndicator(")
        append("category=$category,")
        append("lastObservedAt=$lastObservedAt,")
        append("source=$source,")
        append("sourceUrl=$sourceUrl,")
        append("type=$type,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = category?.hashCode() ?: 0
        result = 31 * result + (lastObservedAt?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (sourceUrl?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ThreatIntelIndicator

        if (category != other.category) return false
        if (lastObservedAt != other.lastObservedAt) return false
        if (source != other.source) return false
        if (sourceUrl != other.sourceUrl) return false
        if (type != other.type) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.ThreatIntelIndicator = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The category of a threat intelligence indicator.
         */
        public var category: aws.sdk.kotlin.services.securityhub.model.ThreatIntelIndicatorCategory? = null
        /**
         * Indicates when the most recent instance of a threat intelligence indicator was observed.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var lastObservedAt: kotlin.String? = null
        /**
         * The source of the threat intelligence indicator.
         */
        public var source: kotlin.String? = null
        /**
         * The URL to the page or site where you can get more information about the threat intelligence indicator.
         */
        public var sourceUrl: kotlin.String? = null
        /**
         * The type of threat intelligence indicator.
         */
        public var type: aws.sdk.kotlin.services.securityhub.model.ThreatIntelIndicatorType? = null
        /**
         * The value of a threat intelligence indicator.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.ThreatIntelIndicator) : this() {
            this.category = x.category
            this.lastObservedAt = x.lastObservedAt
            this.source = x.source
            this.sourceUrl = x.sourceUrl
            this.type = x.type
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.ThreatIntelIndicator = ThreatIntelIndicator(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
