// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides information about the threat detected in a security finding and the file paths that were affected by the threat.
 */
public class Threat private constructor(builder: Builder) {
    /**
     * Provides information about the file paths that were affected by the threat.
     */
    public val filePaths: List<FilePaths>? = builder.filePaths
    /**
     * This total number of items in which the threat has been detected.
     */
    public val itemCount: kotlin.Int? = builder.itemCount
    /**
     * The name of the threat.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The severity of the threat.
     */
    public val severity: kotlin.String? = builder.severity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.Threat = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Threat(")
        append("filePaths=$filePaths,")
        append("itemCount=$itemCount,")
        append("name=$name,")
        append("severity=$severity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = filePaths?.hashCode() ?: 0
        result = 31 * result + (itemCount ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Threat

        if (filePaths != other.filePaths) return false
        if (itemCount != other.itemCount) return false
        if (name != other.name) return false
        if (severity != other.severity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.Threat = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Provides information about the file paths that were affected by the threat.
         */
        public var filePaths: List<FilePaths>? = null
        /**
         * This total number of items in which the threat has been detected.
         */
        public var itemCount: kotlin.Int? = null
        /**
         * The name of the threat.
         */
        public var name: kotlin.String? = null
        /**
         * The severity of the threat.
         */
        public var severity: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.Threat) : this() {
            this.filePaths = x.filePaths
            this.itemCount = x.itemCount
            this.name = x.name
            this.severity = x.severity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.Threat = Threat(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
