// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * A resource that represents your subscription to a supported standard.
 */
public class StandardsSubscription private constructor(builder: Builder) {
    /**
     * The ARN of a standard.
     */
    public val standardsArn: kotlin.String? = builder.standardsArn
    /**
     * A key-value pair of input for the standard.
     */
    public val standardsInput: Map<String, String>? = builder.standardsInput
    /**
     * The status of the standard subscription.
     *
     * The status values are as follows:
     * + `PENDING` - Standard is in the process of being enabled.
     * + `READY` - Standard is enabled.
     * + `INCOMPLETE` - Standard could not be enabled completely. Some controls may not be available.
     * + `DELETING` - Standard is in the process of being disabled.
     * + `FAILED` - Standard could not be disabled.
     */
    public val standardsStatus: aws.sdk.kotlin.services.securityhub.model.StandardsStatus? = builder.standardsStatus
    /**
     * The reason for the current status.
     */
    public val standardsStatusReason: aws.sdk.kotlin.services.securityhub.model.StandardsStatusReason? = builder.standardsStatusReason
    /**
     * The ARN of a resource that represents your subscription to a supported standard.
     */
    public val standardsSubscriptionArn: kotlin.String? = builder.standardsSubscriptionArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.StandardsSubscription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StandardsSubscription(")
        append("standardsArn=$standardsArn,")
        append("standardsInput=$standardsInput,")
        append("standardsStatus=$standardsStatus,")
        append("standardsStatusReason=$standardsStatusReason,")
        append("standardsSubscriptionArn=$standardsSubscriptionArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = standardsArn?.hashCode() ?: 0
        result = 31 * result + (standardsInput?.hashCode() ?: 0)
        result = 31 * result + (standardsStatus?.hashCode() ?: 0)
        result = 31 * result + (standardsStatusReason?.hashCode() ?: 0)
        result = 31 * result + (standardsSubscriptionArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StandardsSubscription

        if (standardsArn != other.standardsArn) return false
        if (standardsInput != other.standardsInput) return false
        if (standardsStatus != other.standardsStatus) return false
        if (standardsStatusReason != other.standardsStatusReason) return false
        if (standardsSubscriptionArn != other.standardsSubscriptionArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.StandardsSubscription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of a standard.
         */
        public var standardsArn: kotlin.String? = null
        /**
         * A key-value pair of input for the standard.
         */
        public var standardsInput: Map<String, String>? = null
        /**
         * The status of the standard subscription.
         *
         * The status values are as follows:
         * + `PENDING` - Standard is in the process of being enabled.
         * + `READY` - Standard is enabled.
         * + `INCOMPLETE` - Standard could not be enabled completely. Some controls may not be available.
         * + `DELETING` - Standard is in the process of being disabled.
         * + `FAILED` - Standard could not be disabled.
         */
        public var standardsStatus: aws.sdk.kotlin.services.securityhub.model.StandardsStatus? = null
        /**
         * The reason for the current status.
         */
        public var standardsStatusReason: aws.sdk.kotlin.services.securityhub.model.StandardsStatusReason? = null
        /**
         * The ARN of a resource that represents your subscription to a supported standard.
         */
        public var standardsSubscriptionArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.StandardsSubscription) : this() {
            this.standardsArn = x.standardsArn
            this.standardsInput = x.standardsInput
            this.standardsStatus = x.standardsStatus
            this.standardsStatusReason = x.standardsStatusReason
            this.standardsSubscriptionArn = x.standardsSubscriptionArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.StandardsSubscription = StandardsSubscription(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.StandardsStatusReason] inside the given [block]
         */
        public fun standardsStatusReason(block: aws.sdk.kotlin.services.securityhub.model.StandardsStatusReason.Builder.() -> kotlin.Unit) {
            this.standardsStatusReason = aws.sdk.kotlin.services.securityhub.model.StandardsStatusReason.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
