// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An array that provides the enablement status and other details for each control that applies to each enabled standard.
 */
public class StandardsControlAssociationSummary private constructor(builder: Builder) {
    /**
     * The enablement status of a control in a specific standard.
     */
    public val associationStatus: aws.sdk.kotlin.services.securityhub.model.AssociationStatus? = builder.associationStatus
    /**
     * The requirement that underlies this control in the compliance framework related to the standard.
     */
    public val relatedRequirements: List<String>? = builder.relatedRequirements
    /**
     * The ARN of a control, such as `arn:aws:securityhub:eu-central-1:123456789012:security-control/S3.1`. This parameter doesn't mention a specific standard.
     */
    public val securityControlArn: kotlin.String? = builder.securityControlArn
    /**
     * A unique standard-agnostic identifier for a control. Values for this field typically consist of an Amazon Web Service and a number, such as APIGateway.5. This field doesn't reference a specific standard.
     */
    public val securityControlId: kotlin.String? = builder.securityControlId
    /**
     * The Amazon Resource Name (ARN) of a standard.
     */
    public val standardsArn: kotlin.String? = builder.standardsArn
    /**
     * The description of a control. This typically summarizes how Security Hub evaluates the control and the conditions under which it produces a failed finding. The parameter may reference a specific standard.
     */
    public val standardsControlDescription: kotlin.String? = builder.standardsControlDescription
    /**
     * The title of a control.
     */
    public val standardsControlTitle: kotlin.String? = builder.standardsControlTitle
    /**
     * The last time that a control's enablement status in a specified standard was updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt
    /**
     * The reason for updating the control's enablement status in a specified standard.
     */
    public val updatedReason: kotlin.String? = builder.updatedReason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.StandardsControlAssociationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StandardsControlAssociationSummary(")
        append("associationStatus=$associationStatus,")
        append("relatedRequirements=$relatedRequirements,")
        append("securityControlArn=$securityControlArn,")
        append("securityControlId=$securityControlId,")
        append("standardsArn=$standardsArn,")
        append("standardsControlDescription=$standardsControlDescription,")
        append("standardsControlTitle=$standardsControlTitle,")
        append("updatedAt=$updatedAt,")
        append("updatedReason=$updatedReason")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associationStatus?.hashCode() ?: 0
        result = 31 * result + (relatedRequirements?.hashCode() ?: 0)
        result = 31 * result + (securityControlArn?.hashCode() ?: 0)
        result = 31 * result + (securityControlId?.hashCode() ?: 0)
        result = 31 * result + (standardsArn?.hashCode() ?: 0)
        result = 31 * result + (standardsControlDescription?.hashCode() ?: 0)
        result = 31 * result + (standardsControlTitle?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        result = 31 * result + (updatedReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StandardsControlAssociationSummary

        if (associationStatus != other.associationStatus) return false
        if (relatedRequirements != other.relatedRequirements) return false
        if (securityControlArn != other.securityControlArn) return false
        if (securityControlId != other.securityControlId) return false
        if (standardsArn != other.standardsArn) return false
        if (standardsControlDescription != other.standardsControlDescription) return false
        if (standardsControlTitle != other.standardsControlTitle) return false
        if (updatedAt != other.updatedAt) return false
        if (updatedReason != other.updatedReason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.StandardsControlAssociationSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The enablement status of a control in a specific standard.
         */
        public var associationStatus: aws.sdk.kotlin.services.securityhub.model.AssociationStatus? = null
        /**
         * The requirement that underlies this control in the compliance framework related to the standard.
         */
        public var relatedRequirements: List<String>? = null
        /**
         * The ARN of a control, such as `arn:aws:securityhub:eu-central-1:123456789012:security-control/S3.1`. This parameter doesn't mention a specific standard.
         */
        public var securityControlArn: kotlin.String? = null
        /**
         * A unique standard-agnostic identifier for a control. Values for this field typically consist of an Amazon Web Service and a number, such as APIGateway.5. This field doesn't reference a specific standard.
         */
        public var securityControlId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of a standard.
         */
        public var standardsArn: kotlin.String? = null
        /**
         * The description of a control. This typically summarizes how Security Hub evaluates the control and the conditions under which it produces a failed finding. The parameter may reference a specific standard.
         */
        public var standardsControlDescription: kotlin.String? = null
        /**
         * The title of a control.
         */
        public var standardsControlTitle: kotlin.String? = null
        /**
         * The last time that a control's enablement status in a specified standard was updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The reason for updating the control's enablement status in a specified standard.
         */
        public var updatedReason: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.StandardsControlAssociationSummary) : this() {
            this.associationStatus = x.associationStatus
            this.relatedRequirements = x.relatedRequirements
            this.securityControlArn = x.securityControlArn
            this.securityControlId = x.securityControlId
            this.standardsArn = x.standardsArn
            this.standardsControlDescription = x.standardsControlDescription
            this.standardsControlTitle = x.standardsControlTitle
            this.updatedAt = x.updatedAt
            this.updatedReason = x.updatedReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.StandardsControlAssociationSummary = StandardsControlAssociationSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
