// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details for an individual security standard control.
 */
public class StandardsControl private constructor(builder: Builder) {
    /**
     * The identifier of the security standard control.
     */
    public val controlId: kotlin.String? = builder.controlId
    /**
     * The current status of the security standard control. Indicates whether the control is enabled or disabled. Security Hub does not check against disabled controls.
     */
    public val controlStatus: aws.sdk.kotlin.services.securityhub.model.ControlStatus? = builder.controlStatus
    /**
     * The date and time that the status of the security standard control was most recently updated.
     */
    public val controlStatusUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.controlStatusUpdatedAt
    /**
     * The longer description of the security standard control. Provides information about what the control is checking for.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The reason provided for the most recent change in status for the control.
     */
    public val disabledReason: kotlin.String? = builder.disabledReason
    /**
     * The list of requirements that are related to this control.
     */
    public val relatedRequirements: List<String>? = builder.relatedRequirements
    /**
     * A link to remediation information for the control in the Security Hub user documentation.
     */
    public val remediationUrl: kotlin.String? = builder.remediationUrl
    /**
     * The severity of findings generated from this security standard control.
     *
     * The finding severity is based on an assessment of how easy it would be to compromise Amazon Web Services resources if the issue is detected.
     */
    public val severityRating: aws.sdk.kotlin.services.securityhub.model.SeverityRating? = builder.severityRating
    /**
     * The ARN of the security standard control.
     */
    public val standardsControlArn: kotlin.String? = builder.standardsControlArn
    /**
     * The title of the security standard control.
     */
    public val title: kotlin.String? = builder.title

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.StandardsControl = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StandardsControl(")
        append("controlId=$controlId,")
        append("controlStatus=$controlStatus,")
        append("controlStatusUpdatedAt=$controlStatusUpdatedAt,")
        append("description=$description,")
        append("disabledReason=$disabledReason,")
        append("relatedRequirements=$relatedRequirements,")
        append("remediationUrl=$remediationUrl,")
        append("severityRating=$severityRating,")
        append("standardsControlArn=$standardsControlArn,")
        append("title=$title")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = controlId?.hashCode() ?: 0
        result = 31 * result + (controlStatus?.hashCode() ?: 0)
        result = 31 * result + (controlStatusUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (disabledReason?.hashCode() ?: 0)
        result = 31 * result + (relatedRequirements?.hashCode() ?: 0)
        result = 31 * result + (remediationUrl?.hashCode() ?: 0)
        result = 31 * result + (severityRating?.hashCode() ?: 0)
        result = 31 * result + (standardsControlArn?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StandardsControl

        if (controlId != other.controlId) return false
        if (controlStatus != other.controlStatus) return false
        if (controlStatusUpdatedAt != other.controlStatusUpdatedAt) return false
        if (description != other.description) return false
        if (disabledReason != other.disabledReason) return false
        if (relatedRequirements != other.relatedRequirements) return false
        if (remediationUrl != other.remediationUrl) return false
        if (severityRating != other.severityRating) return false
        if (standardsControlArn != other.standardsControlArn) return false
        if (title != other.title) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.StandardsControl = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the security standard control.
         */
        public var controlId: kotlin.String? = null
        /**
         * The current status of the security standard control. Indicates whether the control is enabled or disabled. Security Hub does not check against disabled controls.
         */
        public var controlStatus: aws.sdk.kotlin.services.securityhub.model.ControlStatus? = null
        /**
         * The date and time that the status of the security standard control was most recently updated.
         */
        public var controlStatusUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The longer description of the security standard control. Provides information about what the control is checking for.
         */
        public var description: kotlin.String? = null
        /**
         * The reason provided for the most recent change in status for the control.
         */
        public var disabledReason: kotlin.String? = null
        /**
         * The list of requirements that are related to this control.
         */
        public var relatedRequirements: List<String>? = null
        /**
         * A link to remediation information for the control in the Security Hub user documentation.
         */
        public var remediationUrl: kotlin.String? = null
        /**
         * The severity of findings generated from this security standard control.
         *
         * The finding severity is based on an assessment of how easy it would be to compromise Amazon Web Services resources if the issue is detected.
         */
        public var severityRating: aws.sdk.kotlin.services.securityhub.model.SeverityRating? = null
        /**
         * The ARN of the security standard control.
         */
        public var standardsControlArn: kotlin.String? = null
        /**
         * The title of the security standard control.
         */
        public var title: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.StandardsControl) : this() {
            this.controlId = x.controlId
            this.controlStatus = x.controlStatus
            this.controlStatusUpdatedAt = x.controlStatusUpdatedAt
            this.description = x.description
            this.disabledReason = x.disabledReason
            this.relatedRequirements = x.relatedRequirements
            this.remediationUrl = x.remediationUrl
            this.severityRating = x.severityRating
            this.standardsControlArn = x.standardsControlArn
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.StandardsControl = StandardsControl(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
