// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides information about a specific security standard.
 */
public class Standard private constructor(builder: Builder) {
    /**
     * A description of the standard.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Whether the standard is enabled by default. When Security Hub is enabled from the console, if a standard is enabled by default, the check box for that standard is selected by default.
     *
     * When Security Hub is enabled using the `EnableSecurityHub` API operation, the standard is enabled by default unless `EnableDefaultStandards` is set to `false`.
     */
    public val enabledByDefault: kotlin.Boolean? = builder.enabledByDefault
    /**
     * The name of the standard.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The ARN of a standard.
     */
    public val standardsArn: kotlin.String? = builder.standardsArn
    /**
     * Provides details about the management of a standard.
     */
    public val standardsManagedBy: aws.sdk.kotlin.services.securityhub.model.StandardsManagedBy? = builder.standardsManagedBy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.Standard = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Standard(")
        append("description=$description,")
        append("enabledByDefault=$enabledByDefault,")
        append("name=$name,")
        append("standardsArn=$standardsArn,")
        append("standardsManagedBy=$standardsManagedBy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (enabledByDefault?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (standardsArn?.hashCode() ?: 0)
        result = 31 * result + (standardsManagedBy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Standard

        if (description != other.description) return false
        if (enabledByDefault != other.enabledByDefault) return false
        if (name != other.name) return false
        if (standardsArn != other.standardsArn) return false
        if (standardsManagedBy != other.standardsManagedBy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.Standard = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A description of the standard.
         */
        public var description: kotlin.String? = null
        /**
         * Whether the standard is enabled by default. When Security Hub is enabled from the console, if a standard is enabled by default, the check box for that standard is selected by default.
         *
         * When Security Hub is enabled using the `EnableSecurityHub` API operation, the standard is enabled by default unless `EnableDefaultStandards` is set to `false`.
         */
        public var enabledByDefault: kotlin.Boolean? = null
        /**
         * The name of the standard.
         */
        public var name: kotlin.String? = null
        /**
         * The ARN of a standard.
         */
        public var standardsArn: kotlin.String? = null
        /**
         * Provides details about the management of a standard.
         */
        public var standardsManagedBy: aws.sdk.kotlin.services.securityhub.model.StandardsManagedBy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.Standard) : this() {
            this.description = x.description
            this.enabledByDefault = x.enabledByDefault
            this.name = x.name
            this.standardsArn = x.standardsArn
            this.standardsManagedBy = x.standardsManagedBy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.Standard = Standard(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.StandardsManagedBy] inside the given [block]
         */
        public fun standardsManagedBy(block: aws.sdk.kotlin.services.securityhub.model.StandardsManagedBy.Builder.() -> kotlin.Unit) {
            this.standardsManagedBy = aws.sdk.kotlin.services.securityhub.model.StandardsManagedBy.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
