// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Updates to the severity information for a finding.
 */
public class SeverityUpdate private constructor(builder: Builder) {
    /**
     * The severity value of the finding. The allowed values are the following.
     * + `INFORMATIONAL` - No issue was found.
     * + `LOW` - The issue does not require action on its own.
     * + `MEDIUM` - The issue must be addressed but not urgently.
     * + `HIGH` - The issue must be addressed as a priority.
     * + `CRITICAL` - The issue must be remediated immediately to avoid it escalating.
     */
    public val label: aws.sdk.kotlin.services.securityhub.model.SeverityLabel? = builder.label
    /**
     * The normalized severity for the finding. This attribute is to be deprecated in favor of `Label`.
     *
     * If you provide `Normalized` and do not provide `Label`, `Label` is set automatically as follows.
     * + 0 - `INFORMATIONAL`
     * + 1–39 - `LOW`
     * + 40–69 - `MEDIUM`
     * + 70–89 - `HIGH`
     * + 90–100 - `CRITICAL`
     */
    public val normalized: kotlin.Int? = builder.normalized
    /**
     * The native severity as defined by the Amazon Web Services service or integrated partner product that generated the finding.
     */
    public val product: kotlin.Double? = builder.product

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.SeverityUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SeverityUpdate(")
        append("label=$label,")
        append("normalized=$normalized,")
        append("product=$product")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = label?.hashCode() ?: 0
        result = 31 * result + (normalized ?: 0)
        result = 31 * result + (product?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SeverityUpdate

        if (label != other.label) return false
        if (normalized != other.normalized) return false
        if (product != other.product) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.SeverityUpdate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The severity value of the finding. The allowed values are the following.
         * + `INFORMATIONAL` - No issue was found.
         * + `LOW` - The issue does not require action on its own.
         * + `MEDIUM` - The issue must be addressed but not urgently.
         * + `HIGH` - The issue must be addressed as a priority.
         * + `CRITICAL` - The issue must be remediated immediately to avoid it escalating.
         */
        public var label: aws.sdk.kotlin.services.securityhub.model.SeverityLabel? = null
        /**
         * The normalized severity for the finding. This attribute is to be deprecated in favor of `Label`.
         *
         * If you provide `Normalized` and do not provide `Label`, `Label` is set automatically as follows.
         * + 0 - `INFORMATIONAL`
         * + 1–39 - `LOW`
         * + 40–69 - `MEDIUM`
         * + 70–89 - `HIGH`
         * + 90–100 - `CRITICAL`
         */
        public var normalized: kotlin.Int? = null
        /**
         * The native severity as defined by the Amazon Web Services service or integrated partner product that generated the finding.
         */
        public var product: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.SeverityUpdate) : this() {
            this.label = x.label
            this.normalized = x.normalized
            this.product = x.product
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.SeverityUpdate = SeverityUpdate(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
