// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides an overview of the patch compliance status for an instance against a selected compliance standard.
 */
public class PatchSummary private constructor(builder: Builder) {
    /**
     * The number of patches from the compliance standard that failed to install.
     */
    public val failedCount: kotlin.Int? = builder.failedCount
    /**
     * The identifier of the compliance standard that was used to determine the patch compliance status.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The number of patches from the compliance standard that were installed successfully.
     */
    public val installedCount: kotlin.Int? = builder.installedCount
    /**
     * The number of installed patches that are not part of the compliance standard.
     */
    public val installedOtherCount: kotlin.Int? = builder.installedOtherCount
    /**
     * The number of patches that were applied, but that require the instance to be rebooted in order to be marked as installed.
     */
    public val installedPendingReboot: kotlin.Int? = builder.installedPendingReboot
    /**
     * The number of patches that are installed but are also on a list of patches that the customer rejected.
     */
    public val installedRejectedCount: kotlin.Int? = builder.installedRejectedCount
    /**
     * The number of patches that are part of the compliance standard but are not installed. The count includes patches that failed to install.
     */
    public val missingCount: kotlin.Int? = builder.missingCount
    /**
     * The type of patch operation performed. For Patch Manager, the values are `SCAN` and `INSTALL`.
     */
    public val operation: kotlin.String? = builder.operation
    /**
     * Indicates when the operation completed.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val operationEndTime: kotlin.String? = builder.operationEndTime
    /**
     * Indicates when the operation started.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val operationStartTime: kotlin.String? = builder.operationStartTime
    /**
     * The reboot option specified for the instance.
     */
    public val rebootOption: kotlin.String? = builder.rebootOption

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.PatchSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PatchSummary(")
        append("failedCount=$failedCount,")
        append("id=$id,")
        append("installedCount=$installedCount,")
        append("installedOtherCount=$installedOtherCount,")
        append("installedPendingReboot=$installedPendingReboot,")
        append("installedRejectedCount=$installedRejectedCount,")
        append("missingCount=$missingCount,")
        append("operation=$operation,")
        append("operationEndTime=$operationEndTime,")
        append("operationStartTime=$operationStartTime,")
        append("rebootOption=$rebootOption")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = failedCount ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (installedCount ?: 0)
        result = 31 * result + (installedOtherCount ?: 0)
        result = 31 * result + (installedPendingReboot ?: 0)
        result = 31 * result + (installedRejectedCount ?: 0)
        result = 31 * result + (missingCount ?: 0)
        result = 31 * result + (operation?.hashCode() ?: 0)
        result = 31 * result + (operationEndTime?.hashCode() ?: 0)
        result = 31 * result + (operationStartTime?.hashCode() ?: 0)
        result = 31 * result + (rebootOption?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PatchSummary

        if (failedCount != other.failedCount) return false
        if (id != other.id) return false
        if (installedCount != other.installedCount) return false
        if (installedOtherCount != other.installedOtherCount) return false
        if (installedPendingReboot != other.installedPendingReboot) return false
        if (installedRejectedCount != other.installedRejectedCount) return false
        if (missingCount != other.missingCount) return false
        if (operation != other.operation) return false
        if (operationEndTime != other.operationEndTime) return false
        if (operationStartTime != other.operationStartTime) return false
        if (rebootOption != other.rebootOption) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.PatchSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of patches from the compliance standard that failed to install.
         */
        public var failedCount: kotlin.Int? = null
        /**
         * The identifier of the compliance standard that was used to determine the patch compliance status.
         */
        public var id: kotlin.String? = null
        /**
         * The number of patches from the compliance standard that were installed successfully.
         */
        public var installedCount: kotlin.Int? = null
        /**
         * The number of installed patches that are not part of the compliance standard.
         */
        public var installedOtherCount: kotlin.Int? = null
        /**
         * The number of patches that were applied, but that require the instance to be rebooted in order to be marked as installed.
         */
        public var installedPendingReboot: kotlin.Int? = null
        /**
         * The number of patches that are installed but are also on a list of patches that the customer rejected.
         */
        public var installedRejectedCount: kotlin.Int? = null
        /**
         * The number of patches that are part of the compliance standard but are not installed. The count includes patches that failed to install.
         */
        public var missingCount: kotlin.Int? = null
        /**
         * The type of patch operation performed. For Patch Manager, the values are `SCAN` and `INSTALL`.
         */
        public var operation: kotlin.String? = null
        /**
         * Indicates when the operation completed.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var operationEndTime: kotlin.String? = null
        /**
         * Indicates when the operation started.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var operationStartTime: kotlin.String? = null
        /**
         * The reboot option specified for the instance.
         */
        public var rebootOption: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.PatchSummary) : this() {
            this.failedCount = x.failedCount
            this.id = x.id
            this.installedCount = x.installedCount
            this.installedOtherCount = x.installedOtherCount
            this.installedPendingReboot = x.installedPendingReboot
            this.installedRejectedCount = x.installedRejectedCount
            this.missingCount = x.missingCount
            this.operation = x.operation
            this.operationEndTime = x.operationEndTime
            this.operationStartTime = x.operationStartTime
            this.rebootOption = x.rebootOption
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.PatchSummary = PatchSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
