// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details about a member account.
 */
public class Member private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID of the member account.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The Amazon Web Services account ID of the Security Hub administrator account associated with this member account.
     */
    public val administratorId: kotlin.String? = builder.administratorId
    /**
     * The email address of the member account.
     */
    public val email: kotlin.String? = builder.email
    /**
     * A timestamp for the date and time when the invitation was sent to the member account.
     */
    public val invitedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.invitedAt
    /**
     * This is replaced by `AdministratorID`.
     *
     * The Amazon Web Services account ID of the Security Hub administrator account associated with this member account.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val masterId: kotlin.String? = builder.masterId
    /**
     * The status of the relationship between the member account and its administrator account.
     *
     * The status can have one of the following values:
     * + `Created` - Indicates that the administrator account added the member account, but has not yet invited the member account.
     * + `Invited` - Indicates that the administrator account invited the member account. The member account has not yet responded to the invitation.
     * + `Enabled` - Indicates that the member account is currently active. For manually invited member accounts, indicates that the member account accepted the invitation.
     * + `Removed` - Indicates that the administrator account disassociated the member account.
     * + `Resigned` - Indicates that the member account disassociated themselves from the administrator account.
     * + `Deleted` - Indicates that the administrator account deleted the member account.
     * + `AccountSuspended` - Indicates that an organization account was suspended from Amazon Web Services at the same time that the administrator account tried to enable the organization account as a member account.
     */
    public val memberStatus: kotlin.String? = builder.memberStatus
    /**
     * The timestamp for the date and time when the member account was updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.Member = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Member(")
        append("accountId=$accountId,")
        append("administratorId=$administratorId,")
        append("email=$email,")
        append("invitedAt=$invitedAt,")
        append("masterId=$masterId,")
        append("memberStatus=$memberStatus,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (administratorId?.hashCode() ?: 0)
        result = 31 * result + (email?.hashCode() ?: 0)
        result = 31 * result + (invitedAt?.hashCode() ?: 0)
        result = 31 * result + (masterId?.hashCode() ?: 0)
        result = 31 * result + (memberStatus?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Member

        if (accountId != other.accountId) return false
        if (administratorId != other.administratorId) return false
        if (email != other.email) return false
        if (invitedAt != other.invitedAt) return false
        if (masterId != other.masterId) return false
        if (memberStatus != other.memberStatus) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.Member = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Web Services account ID of the member account.
         */
        public var accountId: kotlin.String? = null
        /**
         * The Amazon Web Services account ID of the Security Hub administrator account associated with this member account.
         */
        public var administratorId: kotlin.String? = null
        /**
         * The email address of the member account.
         */
        public var email: kotlin.String? = null
        /**
         * A timestamp for the date and time when the invitation was sent to the member account.
         */
        public var invitedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * This is replaced by `AdministratorID`.
         *
         * The Amazon Web Services account ID of the Security Hub administrator account associated with this member account.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var masterId: kotlin.String? = null
        /**
         * The status of the relationship between the member account and its administrator account.
         *
         * The status can have one of the following values:
         * + `Created` - Indicates that the administrator account added the member account, but has not yet invited the member account.
         * + `Invited` - Indicates that the administrator account invited the member account. The member account has not yet responded to the invitation.
         * + `Enabled` - Indicates that the member account is currently active. For manually invited member accounts, indicates that the member account accepted the invitation.
         * + `Removed` - Indicates that the administrator account disassociated the member account.
         * + `Resigned` - Indicates that the member account disassociated themselves from the administrator account.
         * + `Deleted` - Indicates that the administrator account deleted the member account.
         * + `AccountSuspended` - Indicates that an organization account was suspended from Amazon Web Services at the same time that the administrator account tried to enable the organization account as a member account.
         */
        public var memberStatus: kotlin.String? = null
        /**
         * The timestamp for the date and time when the member account was updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.Member) : this() {
            this.accountId = x.accountId
            this.administratorId = x.administratorId
            this.email = x.email
            this.invitedAt = x.invitedAt
            this.masterId = x.masterId
            this.memberStatus = x.memberStatus
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.Member = Member(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
