// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Defines the behavior of the firewall.
 */
public class FirewallPolicyDetails private constructor(builder: Builder) {
    /**
     * The stateful rule groups that are used in the firewall policy.
     */
    public val statefulRuleGroupReferences: List<FirewallPolicyStatefulRuleGroupReferencesDetails>? = builder.statefulRuleGroupReferences
    /**
     * The custom action definitions that are available to use in the firewall policy's `StatelessDefaultActions` setting.
     */
    public val statelessCustomActions: List<FirewallPolicyStatelessCustomActionsDetails>? = builder.statelessCustomActions
    /**
     * The actions to take on a packet if it doesn't match any of the stateless rules in the policy.
     *
     * You must specify a standard action (`aws:pass`, `aws:drop`, `aws:forward_to_sfe`), and can optionally include a custom action from `StatelessCustomActions`.
     */
    public val statelessDefaultActions: List<String>? = builder.statelessDefaultActions
    /**
     * The actions to take on a fragmented UDP packet if it doesn't match any of the stateless rules in the policy.
     *
     * You must specify a standard action (`aws:pass`, `aws:drop`, `aws:forward_to_sfe`), and can optionally include a custom action from `StatelessCustomActions`.
     */
    public val statelessFragmentDefaultActions: List<String>? = builder.statelessFragmentDefaultActions
    /**
     * The stateless rule groups that are used in the firewall policy.
     */
    public val statelessRuleGroupReferences: List<FirewallPolicyStatelessRuleGroupReferencesDetails>? = builder.statelessRuleGroupReferences

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.FirewallPolicyDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FirewallPolicyDetails(")
        append("statefulRuleGroupReferences=$statefulRuleGroupReferences,")
        append("statelessCustomActions=$statelessCustomActions,")
        append("statelessDefaultActions=$statelessDefaultActions,")
        append("statelessFragmentDefaultActions=$statelessFragmentDefaultActions,")
        append("statelessRuleGroupReferences=$statelessRuleGroupReferences")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = statefulRuleGroupReferences?.hashCode() ?: 0
        result = 31 * result + (statelessCustomActions?.hashCode() ?: 0)
        result = 31 * result + (statelessDefaultActions?.hashCode() ?: 0)
        result = 31 * result + (statelessFragmentDefaultActions?.hashCode() ?: 0)
        result = 31 * result + (statelessRuleGroupReferences?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FirewallPolicyDetails

        if (statefulRuleGroupReferences != other.statefulRuleGroupReferences) return false
        if (statelessCustomActions != other.statelessCustomActions) return false
        if (statelessDefaultActions != other.statelessDefaultActions) return false
        if (statelessFragmentDefaultActions != other.statelessFragmentDefaultActions) return false
        if (statelessRuleGroupReferences != other.statelessRuleGroupReferences) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.FirewallPolicyDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The stateful rule groups that are used in the firewall policy.
         */
        public var statefulRuleGroupReferences: List<FirewallPolicyStatefulRuleGroupReferencesDetails>? = null
        /**
         * The custom action definitions that are available to use in the firewall policy's `StatelessDefaultActions` setting.
         */
        public var statelessCustomActions: List<FirewallPolicyStatelessCustomActionsDetails>? = null
        /**
         * The actions to take on a packet if it doesn't match any of the stateless rules in the policy.
         *
         * You must specify a standard action (`aws:pass`, `aws:drop`, `aws:forward_to_sfe`), and can optionally include a custom action from `StatelessCustomActions`.
         */
        public var statelessDefaultActions: List<String>? = null
        /**
         * The actions to take on a fragmented UDP packet if it doesn't match any of the stateless rules in the policy.
         *
         * You must specify a standard action (`aws:pass`, `aws:drop`, `aws:forward_to_sfe`), and can optionally include a custom action from `StatelessCustomActions`.
         */
        public var statelessFragmentDefaultActions: List<String>? = null
        /**
         * The stateless rule groups that are used in the firewall policy.
         */
        public var statelessRuleGroupReferences: List<FirewallPolicyStatelessRuleGroupReferencesDetails>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.FirewallPolicyDetails) : this() {
            this.statefulRuleGroupReferences = x.statefulRuleGroupReferences
            this.statelessCustomActions = x.statelessCustomActions
            this.statelessDefaultActions = x.statelessDefaultActions
            this.statelessFragmentDefaultActions = x.statelessFragmentDefaultActions
            this.statelessRuleGroupReferences = x.statelessRuleGroupReferences
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.FirewallPolicyDetails = FirewallPolicyDetails(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
