// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Identifies the source of the finding change event.
 */
public class FindingHistoryUpdateSource private constructor(builder: Builder) {
    /**
     * The identity of the source that initiated the finding change event. For example, the Amazon Resource Name (ARN) of a partner that calls BatchImportFindings or of a customer that calls BatchUpdateFindings.
     */
    public val identity: kotlin.String? = builder.identity
    /**
     * Describes the type of finding change event, such as a call to `BatchImportFindings`[](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchImportFindings.html) (by an integrated Amazon Web Service or third party partner integration) or `BatchUpdateFindings`[](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateFindings.html) (by a Security Hub customer).
     */
    public val type: aws.sdk.kotlin.services.securityhub.model.FindingHistoryUpdateSourceType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.FindingHistoryUpdateSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FindingHistoryUpdateSource(")
        append("identity=$identity,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = identity?.hashCode() ?: 0
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FindingHistoryUpdateSource

        if (identity != other.identity) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.FindingHistoryUpdateSource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identity of the source that initiated the finding change event. For example, the Amazon Resource Name (ARN) of a partner that calls BatchImportFindings or of a customer that calls BatchUpdateFindings.
         */
        public var identity: kotlin.String? = null
        /**
         * Describes the type of finding change event, such as a call to `BatchImportFindings`[](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchImportFindings.html) (by an integrated Amazon Web Service or third party partner integration) or `BatchUpdateFindings`[](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateFindings.html) (by a Security Hub customer).
         */
        public var type: aws.sdk.kotlin.services.securityhub.model.FindingHistoryUpdateSourceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.FindingHistoryUpdateSource) : this() {
            this.identity = x.identity
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.FindingHistoryUpdateSource = FindingHistoryUpdateSource(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
