// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A list of events that changed the specified finding during the specified time period. Each record represents a single finding change event.
 */
public class FindingHistoryRecord private constructor(builder: Builder) {
    /**
     * Identifies whether the event marks the creation of a new finding. A value of `True` means that the finding is newly created. A value of `False` means that the finding isn’t newly created.
     */
    public val findingCreated: kotlin.Boolean? = builder.findingCreated
    /**
     * Identifies which finding to get the finding history for.
     */
    public val findingIdentifier: aws.sdk.kotlin.services.securityhub.model.AwsSecurityFindingIdentifier? = builder.findingIdentifier
    /**
     * A token for pagination purposes. Provide this token in the subsequent request to `GetFindingsHistory`[](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_GetFindingsHistory.html) to get up to an additional 100 results of history for the same finding that you specified in your initial request.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Identifies the source of the event that changed the finding. For example, an integrated Amazon Web Service or third-party partner integration may call `BatchImportFindings`[](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchImportFindings.html), or an Security Hub customer may call `BatchUpdateFindings`[](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateFindings.html).
     */
    public val updateSource: aws.sdk.kotlin.services.securityhub.model.FindingHistoryUpdateSource? = builder.updateSource
    /**
     * An ISO 8601-formatted timestamp that indicates when Security Hub processed the updated finding record.
     *
     * A correctly formatted example is `2020-05-21T20:16:34.724Z`. The value cannot contain spaces, and date and time should be separated by `T`. For more information, see [RFC 3339 section 5.6, Internet Date/Time Format](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.updateTime
    /**
     * An array of objects that provides details about the finding change event, including the Amazon Web Services Security Finding Format (ASFF) field that changed, the value of the field before the change, and the value of the field after the change.
     */
    public val updates: List<FindingHistoryUpdate>? = builder.updates

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.FindingHistoryRecord = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FindingHistoryRecord(")
        append("findingCreated=$findingCreated,")
        append("findingIdentifier=$findingIdentifier,")
        append("nextToken=$nextToken,")
        append("updateSource=$updateSource,")
        append("updateTime=$updateTime,")
        append("updates=$updates")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = findingCreated?.hashCode() ?: 0
        result = 31 * result + (findingIdentifier?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (updateSource?.hashCode() ?: 0)
        result = 31 * result + (updateTime?.hashCode() ?: 0)
        result = 31 * result + (updates?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FindingHistoryRecord

        if (findingCreated != other.findingCreated) return false
        if (findingIdentifier != other.findingIdentifier) return false
        if (nextToken != other.nextToken) return false
        if (updateSource != other.updateSource) return false
        if (updateTime != other.updateTime) return false
        if (updates != other.updates) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.FindingHistoryRecord = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Identifies whether the event marks the creation of a new finding. A value of `True` means that the finding is newly created. A value of `False` means that the finding isn’t newly created.
         */
        public var findingCreated: kotlin.Boolean? = null
        /**
         * Identifies which finding to get the finding history for.
         */
        public var findingIdentifier: aws.sdk.kotlin.services.securityhub.model.AwsSecurityFindingIdentifier? = null
        /**
         * A token for pagination purposes. Provide this token in the subsequent request to `GetFindingsHistory`[](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_GetFindingsHistory.html) to get up to an additional 100 results of history for the same finding that you specified in your initial request.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Identifies the source of the event that changed the finding. For example, an integrated Amazon Web Service or third-party partner integration may call `BatchImportFindings`[](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchImportFindings.html), or an Security Hub customer may call `BatchUpdateFindings`[](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateFindings.html).
         */
        public var updateSource: aws.sdk.kotlin.services.securityhub.model.FindingHistoryUpdateSource? = null
        /**
         * An ISO 8601-formatted timestamp that indicates when Security Hub processed the updated finding record.
         *
         * A correctly formatted example is `2020-05-21T20:16:34.724Z`. The value cannot contain spaces, and date and time should be separated by `T`. For more information, see [RFC 3339 section 5.6, Internet Date/Time Format](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An array of objects that provides details about the finding change event, including the Amazon Web Services Security Finding Format (ASFF) field that changed, the value of the field before the change, and the value of the field after the change.
         */
        public var updates: List<FindingHistoryUpdate>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.FindingHistoryRecord) : this() {
            this.findingCreated = x.findingCreated
            this.findingIdentifier = x.findingIdentifier
            this.nextToken = x.nextToken
            this.updateSource = x.updateSource
            this.updateTime = x.updateTime
            this.updates = x.updates
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.FindingHistoryRecord = FindingHistoryRecord(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsSecurityFindingIdentifier] inside the given [block]
         */
        public fun findingIdentifier(block: aws.sdk.kotlin.services.securityhub.model.AwsSecurityFindingIdentifier.Builder.() -> kotlin.Unit) {
            this.findingIdentifier = aws.sdk.kotlin.services.securityhub.model.AwsSecurityFindingIdentifier.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.FindingHistoryUpdateSource] inside the given [block]
         */
        public fun updateSource(block: aws.sdk.kotlin.services.securityhub.model.FindingHistoryUpdateSource.Builder.() -> kotlin.Unit) {
            this.updateSource = aws.sdk.kotlin.services.securityhub.model.FindingHistoryUpdateSource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
