// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



public class EnableSecurityHubRequest private constructor(builder: Builder) {
    /**
     * This field, used when enabling Security Hub, specifies whether the calling account has consolidated control findings turned on. If the value for this field is set to `SECURITY_CONTROL`, Security Hub generates a single finding for a control check even when the check applies to multiple enabled standards.
     *
     * If the value for this field is set to `STANDARD_CONTROL`, Security Hub generates separate findings for a control check when the check applies to multiple enabled standards.
     *
     * The value for this field in a member account matches the value in the administrator account. For accounts that aren't part of an organization, the default value of this field is `SECURITY_CONTROL` if you enabled Security Hub on or after February 23, 2023.
     */
    public val controlFindingGenerator: aws.sdk.kotlin.services.securityhub.model.ControlFindingGenerator? = builder.controlFindingGenerator
    /**
     * Whether to enable the security standards that Security Hub has designated as automatically enabled. If you do not provide a value for `EnableDefaultStandards`, it is set to `true`. To not enable the automatically enabled standards, set `EnableDefaultStandards` to `false`.
     */
    public val enableDefaultStandards: kotlin.Boolean? = builder.enableDefaultStandards
    /**
     * The tags to add to the hub resource when you enable Security Hub.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.EnableSecurityHubRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EnableSecurityHubRequest(")
        append("controlFindingGenerator=$controlFindingGenerator,")
        append("enableDefaultStandards=$enableDefaultStandards,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = controlFindingGenerator?.hashCode() ?: 0
        result = 31 * result + (enableDefaultStandards?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EnableSecurityHubRequest

        if (controlFindingGenerator != other.controlFindingGenerator) return false
        if (enableDefaultStandards != other.enableDefaultStandards) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.EnableSecurityHubRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * This field, used when enabling Security Hub, specifies whether the calling account has consolidated control findings turned on. If the value for this field is set to `SECURITY_CONTROL`, Security Hub generates a single finding for a control check even when the check applies to multiple enabled standards.
         *
         * If the value for this field is set to `STANDARD_CONTROL`, Security Hub generates separate findings for a control check when the check applies to multiple enabled standards.
         *
         * The value for this field in a member account matches the value in the administrator account. For accounts that aren't part of an organization, the default value of this field is `SECURITY_CONTROL` if you enabled Security Hub on or after February 23, 2023.
         */
        public var controlFindingGenerator: aws.sdk.kotlin.services.securityhub.model.ControlFindingGenerator? = null
        /**
         * Whether to enable the security standards that Security Hub has designated as automatically enabled. If you do not provide a value for `EnableDefaultStandards`, it is set to `true`. To not enable the automatically enabled standards, set `EnableDefaultStandards` to `false`.
         */
        public var enableDefaultStandards: kotlin.Boolean? = null
        /**
         * The tags to add to the hub resource when you enable Security Hub.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.EnableSecurityHubRequest) : this() {
            this.controlFindingGenerator = x.controlFindingGenerator
            this.enableDefaultStandards = x.enableDefaultStandards
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.EnableSecurityHubRequest = EnableSecurityHubRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
