// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



public class BatchUpdateFindingsRequest private constructor(builder: Builder) {
    /**
     * The updated value for the finding confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.
     *
     * Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence.
     */
    public val confidence: kotlin.Int? = builder.confidence
    /**
     * The updated value for the level of importance assigned to the resources associated with the findings.
     *
     * A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.
     */
    public val criticality: kotlin.Int? = builder.criticality
    /**
     * The list of findings to update. `BatchUpdateFindings` can be used to update up to 100 findings at a time.
     *
     * For each finding, the list provides the finding identifier and the ARN of the finding provider.
     */
    public val findingIdentifiers: List<AwsSecurityFindingIdentifier>? = builder.findingIdentifiers
    /**
     * The updated note.
     */
    public val note: aws.sdk.kotlin.services.securityhub.model.NoteUpdate? = builder.note
    /**
     * A list of findings that are related to the updated findings.
     */
    public val relatedFindings: List<RelatedFinding>? = builder.relatedFindings
    /**
     * Used to update the finding severity.
     */
    public val severity: aws.sdk.kotlin.services.securityhub.model.SeverityUpdate? = builder.severity
    /**
     * One or more finding types in the format of namespace/category/classifier that classify a finding.
     *
     * Valid namespace values are as follows.
     * + Software and Configuration Checks
     * + TTPs
     * + Effects
     * + Unusual Behaviors
     * + Sensitive Data Identifications
     */
    public val types: List<String>? = builder.types
    /**
     * A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a finding.
     */
    public val userDefinedFields: Map<String, String>? = builder.userDefinedFields
    /**
     * Indicates the veracity of a finding.
     *
     * The available values for `VerificationState` are as follows.
     * + `UNKNOWN` – The default disposition of a security finding
     * + `TRUE_POSITIVE` – The security finding is confirmed
     * + `FALSE_POSITIVE` – The security finding was determined to be a false alarm
     * + `BENIGN_POSITIVE` – A special case of `TRUE_POSITIVE` where the finding doesn't pose any threat, is expected, or both
     */
    public val verificationState: aws.sdk.kotlin.services.securityhub.model.VerificationState? = builder.verificationState
    /**
     * Used to update the workflow status of a finding.
     *
     * The workflow status indicates the progress of the investigation into the finding.
     */
    public val workflow: aws.sdk.kotlin.services.securityhub.model.WorkflowUpdate? = builder.workflow

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.BatchUpdateFindingsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchUpdateFindingsRequest(")
        append("confidence=$confidence,")
        append("criticality=$criticality,")
        append("findingIdentifiers=$findingIdentifiers,")
        append("note=$note,")
        append("relatedFindings=$relatedFindings,")
        append("severity=$severity,")
        append("types=$types,")
        append("userDefinedFields=$userDefinedFields,")
        append("verificationState=$verificationState,")
        append("workflow=$workflow")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = confidence ?: 0
        result = 31 * result + (criticality ?: 0)
        result = 31 * result + (findingIdentifiers?.hashCode() ?: 0)
        result = 31 * result + (note?.hashCode() ?: 0)
        result = 31 * result + (relatedFindings?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (types?.hashCode() ?: 0)
        result = 31 * result + (userDefinedFields?.hashCode() ?: 0)
        result = 31 * result + (verificationState?.hashCode() ?: 0)
        result = 31 * result + (workflow?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchUpdateFindingsRequest

        if (confidence != other.confidence) return false
        if (criticality != other.criticality) return false
        if (findingIdentifiers != other.findingIdentifiers) return false
        if (note != other.note) return false
        if (relatedFindings != other.relatedFindings) return false
        if (severity != other.severity) return false
        if (types != other.types) return false
        if (userDefinedFields != other.userDefinedFields) return false
        if (verificationState != other.verificationState) return false
        if (workflow != other.workflow) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.BatchUpdateFindingsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The updated value for the finding confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.
         *
         * Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence.
         */
        public var confidence: kotlin.Int? = null
        /**
         * The updated value for the level of importance assigned to the resources associated with the findings.
         *
         * A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.
         */
        public var criticality: kotlin.Int? = null
        /**
         * The list of findings to update. `BatchUpdateFindings` can be used to update up to 100 findings at a time.
         *
         * For each finding, the list provides the finding identifier and the ARN of the finding provider.
         */
        public var findingIdentifiers: List<AwsSecurityFindingIdentifier>? = null
        /**
         * The updated note.
         */
        public var note: aws.sdk.kotlin.services.securityhub.model.NoteUpdate? = null
        /**
         * A list of findings that are related to the updated findings.
         */
        public var relatedFindings: List<RelatedFinding>? = null
        /**
         * Used to update the finding severity.
         */
        public var severity: aws.sdk.kotlin.services.securityhub.model.SeverityUpdate? = null
        /**
         * One or more finding types in the format of namespace/category/classifier that classify a finding.
         *
         * Valid namespace values are as follows.
         * + Software and Configuration Checks
         * + TTPs
         * + Effects
         * + Unusual Behaviors
         * + Sensitive Data Identifications
         */
        public var types: List<String>? = null
        /**
         * A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a finding.
         */
        public var userDefinedFields: Map<String, String>? = null
        /**
         * Indicates the veracity of a finding.
         *
         * The available values for `VerificationState` are as follows.
         * + `UNKNOWN` – The default disposition of a security finding
         * + `TRUE_POSITIVE` – The security finding is confirmed
         * + `FALSE_POSITIVE` – The security finding was determined to be a false alarm
         * + `BENIGN_POSITIVE` – A special case of `TRUE_POSITIVE` where the finding doesn't pose any threat, is expected, or both
         */
        public var verificationState: aws.sdk.kotlin.services.securityhub.model.VerificationState? = null
        /**
         * Used to update the workflow status of a finding.
         *
         * The workflow status indicates the progress of the investigation into the finding.
         */
        public var workflow: aws.sdk.kotlin.services.securityhub.model.WorkflowUpdate? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.BatchUpdateFindingsRequest) : this() {
            this.confidence = x.confidence
            this.criticality = x.criticality
            this.findingIdentifiers = x.findingIdentifiers
            this.note = x.note
            this.relatedFindings = x.relatedFindings
            this.severity = x.severity
            this.types = x.types
            this.userDefinedFields = x.userDefinedFields
            this.verificationState = x.verificationState
            this.workflow = x.workflow
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.BatchUpdateFindingsRequest = BatchUpdateFindingsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.NoteUpdate] inside the given [block]
         */
        public fun note(block: aws.sdk.kotlin.services.securityhub.model.NoteUpdate.Builder.() -> kotlin.Unit) {
            this.note = aws.sdk.kotlin.services.securityhub.model.NoteUpdate.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.SeverityUpdate] inside the given [block]
         */
        public fun severity(block: aws.sdk.kotlin.services.securityhub.model.SeverityUpdate.Builder.() -> kotlin.Unit) {
            this.severity = aws.sdk.kotlin.services.securityhub.model.SeverityUpdate.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.WorkflowUpdate] inside the given [block]
         */
        public fun workflow(block: aws.sdk.kotlin.services.securityhub.model.WorkflowUpdate.Builder.() -> kotlin.Unit) {
            this.workflow = aws.sdk.kotlin.services.securityhub.model.WorkflowUpdate.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
