// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Details about an WAFv2 web Access Control List (ACL).
 */
public class AwsWafv2WebAclDetails private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the web ACL that you want to associate with the resource.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The web ACL capacity units (WCUs) currently being used by this web ACL.
     */
    public val capacity: kotlin.Long? = builder.capacity
    /**
     * Specifies how WAF should handle CAPTCHA evaluations for rules that don't have their own `CaptchaConfig` settings.
     */
    public val captchaConfig: aws.sdk.kotlin.services.securityhub.model.AwsWafv2WebAclCaptchaConfigDetails? = builder.captchaConfig
    /**
     * The action to perform if none of the Rules contained in the web ACL match.
     */
    public val defaultAction: aws.sdk.kotlin.services.securityhub.model.AwsWafv2WebAclActionDetails? = builder.defaultAction
    /**
     * A description of the web ACL that helps with identification.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A unique identifier for the web ACL.
     */
    public val id: kotlin.String? = builder.id
    /**
     * Indicates whether this web ACL is managed by Firewall Manager.
     */
    public val managedbyFirewallManager: kotlin.Boolean? = builder.managedbyFirewallManager
    /**
     * The name of the web ACL.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Rule statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them.
     */
    public val rules: List<AwsWafv2RulesDetails>? = builder.rules
    /**
     * Defines and enables Amazon CloudWatch metrics and web request sample collection.
     */
    public val visibilityConfig: aws.sdk.kotlin.services.securityhub.model.AwsWafv2VisibilityConfigDetails? = builder.visibilityConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsWafv2WebAclDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsWafv2WebAclDetails(")
        append("arn=$arn,")
        append("capacity=$capacity,")
        append("captchaConfig=$captchaConfig,")
        append("defaultAction=$defaultAction,")
        append("description=$description,")
        append("id=$id,")
        append("managedbyFirewallManager=$managedbyFirewallManager,")
        append("name=$name,")
        append("rules=$rules,")
        append("visibilityConfig=$visibilityConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (capacity?.hashCode() ?: 0)
        result = 31 * result + (captchaConfig?.hashCode() ?: 0)
        result = 31 * result + (defaultAction?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (managedbyFirewallManager?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (rules?.hashCode() ?: 0)
        result = 31 * result + (visibilityConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsWafv2WebAclDetails

        if (arn != other.arn) return false
        if (capacity != other.capacity) return false
        if (captchaConfig != other.captchaConfig) return false
        if (defaultAction != other.defaultAction) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (managedbyFirewallManager != other.managedbyFirewallManager) return false
        if (name != other.name) return false
        if (rules != other.rules) return false
        if (visibilityConfig != other.visibilityConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsWafv2WebAclDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the web ACL that you want to associate with the resource.
         */
        public var arn: kotlin.String? = null
        /**
         * The web ACL capacity units (WCUs) currently being used by this web ACL.
         */
        public var capacity: kotlin.Long? = null
        /**
         * Specifies how WAF should handle CAPTCHA evaluations for rules that don't have their own `CaptchaConfig` settings.
         */
        public var captchaConfig: aws.sdk.kotlin.services.securityhub.model.AwsWafv2WebAclCaptchaConfigDetails? = null
        /**
         * The action to perform if none of the Rules contained in the web ACL match.
         */
        public var defaultAction: aws.sdk.kotlin.services.securityhub.model.AwsWafv2WebAclActionDetails? = null
        /**
         * A description of the web ACL that helps with identification.
         */
        public var description: kotlin.String? = null
        /**
         * A unique identifier for the web ACL.
         */
        public var id: kotlin.String? = null
        /**
         * Indicates whether this web ACL is managed by Firewall Manager.
         */
        public var managedbyFirewallManager: kotlin.Boolean? = null
        /**
         * The name of the web ACL.
         */
        public var name: kotlin.String? = null
        /**
         * The Rule statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them.
         */
        public var rules: List<AwsWafv2RulesDetails>? = null
        /**
         * Defines and enables Amazon CloudWatch metrics and web request sample collection.
         */
        public var visibilityConfig: aws.sdk.kotlin.services.securityhub.model.AwsWafv2VisibilityConfigDetails? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsWafv2WebAclDetails) : this() {
            this.arn = x.arn
            this.capacity = x.capacity
            this.captchaConfig = x.captchaConfig
            this.defaultAction = x.defaultAction
            this.description = x.description
            this.id = x.id
            this.managedbyFirewallManager = x.managedbyFirewallManager
            this.name = x.name
            this.rules = x.rules
            this.visibilityConfig = x.visibilityConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsWafv2WebAclDetails = AwsWafv2WebAclDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsWafv2WebAclCaptchaConfigDetails] inside the given [block]
         */
        public fun captchaConfig(block: aws.sdk.kotlin.services.securityhub.model.AwsWafv2WebAclCaptchaConfigDetails.Builder.() -> kotlin.Unit) {
            this.captchaConfig = aws.sdk.kotlin.services.securityhub.model.AwsWafv2WebAclCaptchaConfigDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsWafv2WebAclActionDetails] inside the given [block]
         */
        public fun defaultAction(block: aws.sdk.kotlin.services.securityhub.model.AwsWafv2WebAclActionDetails.Builder.() -> kotlin.Unit) {
            this.defaultAction = aws.sdk.kotlin.services.securityhub.model.AwsWafv2WebAclActionDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsWafv2VisibilityConfigDetails] inside the given [block]
         */
        public fun visibilityConfig(block: aws.sdk.kotlin.services.securityhub.model.AwsWafv2VisibilityConfigDetails.Builder.() -> kotlin.Unit) {
            this.visibilityConfig = aws.sdk.kotlin.services.securityhub.model.AwsWafv2VisibilityConfigDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
