// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides details about rules in a rule group. A rule identifies web requests that you want to allow, block, or count. Each rule includes one top-level Statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them.
 */
public class AwsWafv2RulesDetails private constructor(builder: Builder) {
    /**
     * The action that WAF should take on a web request when it matches the rule statement. Settings at the web ACL level can override the rule action setting.
     */
    public val action: aws.sdk.kotlin.services.securityhub.model.AwsWafv2RulesActionDetails? = builder.action
    /**
     * The name of the rule.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The action to use in the place of the action that results from the rule group evaluation.
     */
    public val overrideAction: kotlin.String? = builder.overrideAction
    /**
     * If you define more than one Rule in a WebACL, WAF evaluates each request against the Rules in order based on the value of `Priority`. WAF processes rules with lower priority first. The priorities don't need to be consecutive, but they must all be different.
     */
    public val priority: kotlin.Int? = builder.priority
    /**
     * Defines and enables Amazon CloudWatch metrics and web request sample collection.
     */
    public val visibilityConfig: aws.sdk.kotlin.services.securityhub.model.AwsWafv2VisibilityConfigDetails? = builder.visibilityConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsWafv2RulesDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsWafv2RulesDetails(")
        append("action=$action,")
        append("name=$name,")
        append("overrideAction=$overrideAction,")
        append("priority=$priority,")
        append("visibilityConfig=$visibilityConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (overrideAction?.hashCode() ?: 0)
        result = 31 * result + (priority ?: 0)
        result = 31 * result + (visibilityConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsWafv2RulesDetails

        if (action != other.action) return false
        if (name != other.name) return false
        if (overrideAction != other.overrideAction) return false
        if (priority != other.priority) return false
        if (visibilityConfig != other.visibilityConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsWafv2RulesDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The action that WAF should take on a web request when it matches the rule statement. Settings at the web ACL level can override the rule action setting.
         */
        public var action: aws.sdk.kotlin.services.securityhub.model.AwsWafv2RulesActionDetails? = null
        /**
         * The name of the rule.
         */
        public var name: kotlin.String? = null
        /**
         * The action to use in the place of the action that results from the rule group evaluation.
         */
        public var overrideAction: kotlin.String? = null
        /**
         * If you define more than one Rule in a WebACL, WAF evaluates each request against the Rules in order based on the value of `Priority`. WAF processes rules with lower priority first. The priorities don't need to be consecutive, but they must all be different.
         */
        public var priority: kotlin.Int? = null
        /**
         * Defines and enables Amazon CloudWatch metrics and web request sample collection.
         */
        public var visibilityConfig: aws.sdk.kotlin.services.securityhub.model.AwsWafv2VisibilityConfigDetails? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsWafv2RulesDetails) : this() {
            this.action = x.action
            this.name = x.name
            this.overrideAction = x.overrideAction
            this.priority = x.priority
            this.visibilityConfig = x.visibilityConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsWafv2RulesDetails = AwsWafv2RulesDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsWafv2RulesActionDetails] inside the given [block]
         */
        public fun action(block: aws.sdk.kotlin.services.securityhub.model.AwsWafv2RulesActionDetails.Builder.() -> kotlin.Unit) {
            this.action = aws.sdk.kotlin.services.securityhub.model.AwsWafv2RulesActionDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsWafv2VisibilityConfigDetails] inside the given [block]
         */
        public fun visibilityConfig(block: aws.sdk.kotlin.services.securityhub.model.AwsWafv2VisibilityConfigDetails.Builder.() -> kotlin.Unit) {
            this.visibilityConfig = aws.sdk.kotlin.services.securityhub.model.AwsWafv2VisibilityConfigDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
