// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Details about an WAFv2 rule group.
 */
public class AwsWafv2RuleGroupDetails private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the entity.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The web ACL capacity units (WCUs) required for this rule group.
     */
    public val capacity: kotlin.Long? = builder.capacity
    /**
     * A description of the rule group that helps with identification.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A unique identifier for the rule group.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The name of the rule group. You cannot change the name of a rule group after you create it.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Rule statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them.
     */
    public val rules: List<AwsWafv2RulesDetails>? = builder.rules
    /**
     * Specifies whether the rule group is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, or an Amazon Cognito user pool.
     */
    public val scope: kotlin.String? = builder.scope
    /**
     * Defines and enables Amazon CloudWatch metrics and web request sample collection.
     */
    public val visibilityConfig: aws.sdk.kotlin.services.securityhub.model.AwsWafv2VisibilityConfigDetails? = builder.visibilityConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsWafv2RuleGroupDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsWafv2RuleGroupDetails(")
        append("arn=$arn,")
        append("capacity=$capacity,")
        append("description=$description,")
        append("id=$id,")
        append("name=$name,")
        append("rules=$rules,")
        append("scope=$scope,")
        append("visibilityConfig=$visibilityConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (capacity?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (rules?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        result = 31 * result + (visibilityConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsWafv2RuleGroupDetails

        if (arn != other.arn) return false
        if (capacity != other.capacity) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (rules != other.rules) return false
        if (scope != other.scope) return false
        if (visibilityConfig != other.visibilityConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsWafv2RuleGroupDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the entity.
         */
        public var arn: kotlin.String? = null
        /**
         * The web ACL capacity units (WCUs) required for this rule group.
         */
        public var capacity: kotlin.Long? = null
        /**
         * A description of the rule group that helps with identification.
         */
        public var description: kotlin.String? = null
        /**
         * A unique identifier for the rule group.
         */
        public var id: kotlin.String? = null
        /**
         * The name of the rule group. You cannot change the name of a rule group after you create it.
         */
        public var name: kotlin.String? = null
        /**
         * The Rule statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them.
         */
        public var rules: List<AwsWafv2RulesDetails>? = null
        /**
         * Specifies whether the rule group is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, or an Amazon Cognito user pool.
         */
        public var scope: kotlin.String? = null
        /**
         * Defines and enables Amazon CloudWatch metrics and web request sample collection.
         */
        public var visibilityConfig: aws.sdk.kotlin.services.securityhub.model.AwsWafv2VisibilityConfigDetails? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsWafv2RuleGroupDetails) : this() {
            this.arn = x.arn
            this.capacity = x.capacity
            this.description = x.description
            this.id = x.id
            this.name = x.name
            this.rules = x.rules
            this.scope = x.scope
            this.visibilityConfig = x.visibilityConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsWafv2RuleGroupDetails = AwsWafv2RuleGroupDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsWafv2VisibilityConfigDetails] inside the given [block]
         */
        public fun visibilityConfig(block: aws.sdk.kotlin.services.securityhub.model.AwsWafv2VisibilityConfigDetails.Builder.() -> kotlin.Unit) {
            this.visibilityConfig = aws.sdk.kotlin.services.securityhub.model.AwsWafv2VisibilityConfigDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
