// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Details for a rule in an WAF web ACL.
 */
public class AwsWafWebAclRule private constructor(builder: Builder) {
    /**
     * Specifies the action that CloudFront or WAF takes when a web request matches the conditions in the rule.
     */
    public val action: aws.sdk.kotlin.services.securityhub.model.WafAction? = builder.action
    /**
     * Rules to exclude from a rule group.
     */
    public val excludedRules: List<WafExcludedRule>? = builder.excludedRules
    /**
     * Use the `OverrideAction` to test your `RuleGroup`.
     *
     * Any rule in a `RuleGroup` can potentially block a request. If you set the `OverrideAction` to `None`, the `RuleGroup` blocks a request if any individual rule in the `RuleGroup` matches the request and is configured to block that request.
     *
     * However, if you first want to test the `RuleGroup`, set the `OverrideAction` to `Count`. The `RuleGroup` then overrides any block action specified by individual rules contained within the group. Instead of blocking matching requests, those requests are counted.
     *
     * `ActivatedRule`|`OverrideAction` applies only when updating or adding a `RuleGroup` to a web ACL. In this case you do not use `ActivatedRule``Action`. For all other update requests, `ActivatedRule``Action` is used instead of `ActivatedRule``OverrideAction`.
     */
    public val overrideAction: aws.sdk.kotlin.services.securityhub.model.WafOverrideAction? = builder.overrideAction
    /**
     * Specifies the order in which the rules in a web ACL are evaluated. Rules with a lower value for `Priority` are evaluated before rules with a higher value. The value must be a unique integer. If you add multiple rules to a web ACL, the values do not need to be consecutive.
     */
    public val priority: kotlin.Int? = builder.priority
    /**
     * The identifier for a rule.
     */
    public val ruleId: kotlin.String? = builder.ruleId
    /**
     * The rule type.
     *
     * Valid values: `REGULAR` | `RATE_BASED` | `GROUP`
     *
     * The default is `REGULAR`.
     */
    public val type: kotlin.String? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsWafWebAclRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsWafWebAclRule(")
        append("action=$action,")
        append("excludedRules=$excludedRules,")
        append("overrideAction=$overrideAction,")
        append("priority=$priority,")
        append("ruleId=$ruleId,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (excludedRules?.hashCode() ?: 0)
        result = 31 * result + (overrideAction?.hashCode() ?: 0)
        result = 31 * result + (priority ?: 0)
        result = 31 * result + (ruleId?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsWafWebAclRule

        if (action != other.action) return false
        if (excludedRules != other.excludedRules) return false
        if (overrideAction != other.overrideAction) return false
        if (priority != other.priority) return false
        if (ruleId != other.ruleId) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsWafWebAclRule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the action that CloudFront or WAF takes when a web request matches the conditions in the rule.
         */
        public var action: aws.sdk.kotlin.services.securityhub.model.WafAction? = null
        /**
         * Rules to exclude from a rule group.
         */
        public var excludedRules: List<WafExcludedRule>? = null
        /**
         * Use the `OverrideAction` to test your `RuleGroup`.
         *
         * Any rule in a `RuleGroup` can potentially block a request. If you set the `OverrideAction` to `None`, the `RuleGroup` blocks a request if any individual rule in the `RuleGroup` matches the request and is configured to block that request.
         *
         * However, if you first want to test the `RuleGroup`, set the `OverrideAction` to `Count`. The `RuleGroup` then overrides any block action specified by individual rules contained within the group. Instead of blocking matching requests, those requests are counted.
         *
         * `ActivatedRule`|`OverrideAction` applies only when updating or adding a `RuleGroup` to a web ACL. In this case you do not use `ActivatedRule``Action`. For all other update requests, `ActivatedRule``Action` is used instead of `ActivatedRule``OverrideAction`.
         */
        public var overrideAction: aws.sdk.kotlin.services.securityhub.model.WafOverrideAction? = null
        /**
         * Specifies the order in which the rules in a web ACL are evaluated. Rules with a lower value for `Priority` are evaluated before rules with a higher value. The value must be a unique integer. If you add multiple rules to a web ACL, the values do not need to be consecutive.
         */
        public var priority: kotlin.Int? = null
        /**
         * The identifier for a rule.
         */
        public var ruleId: kotlin.String? = null
        /**
         * The rule type.
         *
         * Valid values: `REGULAR` | `RATE_BASED` | `GROUP`
         *
         * The default is `REGULAR`.
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsWafWebAclRule) : this() {
            this.action = x.action
            this.excludedRules = x.excludedRules
            this.overrideAction = x.overrideAction
            this.priority = x.priority
            this.ruleId = x.ruleId
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsWafWebAclRule = AwsWafWebAclRule(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.WafAction] inside the given [block]
         */
        public fun action(block: aws.sdk.kotlin.services.securityhub.model.WafAction.Builder.() -> kotlin.Unit) {
            this.action = aws.sdk.kotlin.services.securityhub.model.WafAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.WafOverrideAction] inside the given [block]
         */
        public fun overrideAction(block: aws.sdk.kotlin.services.securityhub.model.WafOverrideAction.Builder.() -> kotlin.Unit) {
            this.overrideAction = aws.sdk.kotlin.services.securityhub.model.WafOverrideAction.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
