// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * contains details about a rate-based rule for Regional resources. A rate-based rule provides settings to indicate when to allow, block, or count a request. Rate-based rules include the number of requests that arrive over a specified period of time.
 */
public class AwsWafRegionalRateBasedRuleDetails private constructor(builder: Builder) {
    /**
     * The predicates to include in the rate-based rule.
     */
    public val matchPredicates: List<AwsWafRegionalRateBasedRuleMatchPredicate>? = builder.matchPredicates
    /**
     * The name of the metrics for the rate-based rule.
     */
    public val metricName: kotlin.String? = builder.metricName
    /**
     * The name of the rate-based rule.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The field that WAF uses to determine whether requests are likely arriving from single source and are subject to rate monitoring.
     */
    public val rateKey: kotlin.String? = builder.rateKey
    /**
     * The maximum number of requests that have an identical value for the field specified in `RateKey` that are allowed within a five-minute period. If the number of requests exceeds `RateLimit` and the other predicates specified in the rule are met, WAF triggers the action for the rule.
     */
    public val rateLimit: kotlin.Long? = builder.rateLimit
    /**
     * The unique identifier for the rate-based rule.
     */
    public val ruleId: kotlin.String? = builder.ruleId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsWafRegionalRateBasedRuleDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsWafRegionalRateBasedRuleDetails(")
        append("matchPredicates=$matchPredicates,")
        append("metricName=$metricName,")
        append("name=$name,")
        append("rateKey=$rateKey,")
        append("rateLimit=$rateLimit,")
        append("ruleId=$ruleId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = matchPredicates?.hashCode() ?: 0
        result = 31 * result + (metricName?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (rateKey?.hashCode() ?: 0)
        result = 31 * result + (rateLimit?.hashCode() ?: 0)
        result = 31 * result + (ruleId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsWafRegionalRateBasedRuleDetails

        if (matchPredicates != other.matchPredicates) return false
        if (metricName != other.metricName) return false
        if (name != other.name) return false
        if (rateKey != other.rateKey) return false
        if (rateLimit != other.rateLimit) return false
        if (ruleId != other.ruleId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsWafRegionalRateBasedRuleDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The predicates to include in the rate-based rule.
         */
        public var matchPredicates: List<AwsWafRegionalRateBasedRuleMatchPredicate>? = null
        /**
         * The name of the metrics for the rate-based rule.
         */
        public var metricName: kotlin.String? = null
        /**
         * The name of the rate-based rule.
         */
        public var name: kotlin.String? = null
        /**
         * The field that WAF uses to determine whether requests are likely arriving from single source and are subject to rate monitoring.
         */
        public var rateKey: kotlin.String? = null
        /**
         * The maximum number of requests that have an identical value for the field specified in `RateKey` that are allowed within a five-minute period. If the number of requests exceeds `RateLimit` and the other predicates specified in the rule are met, WAF triggers the action for the rule.
         */
        public var rateLimit: kotlin.Long? = null
        /**
         * The unique identifier for the rate-based rule.
         */
        public var ruleId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsWafRegionalRateBasedRuleDetails) : this() {
            this.matchPredicates = x.matchPredicates
            this.metricName = x.metricName
            this.name = x.name
            this.rateKey = x.rateKey
            this.rateLimit = x.rateLimit
            this.ruleId = x.ruleId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsWafRegionalRateBasedRuleDetails = AwsWafRegionalRateBasedRuleDetails(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
