// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides details about an Amazon SageMaker notebook instance.
 */
public class AwsSageMakerNotebookInstanceDetails private constructor(builder: Builder) {
    /**
     * A list of Amazon Elastic Inference instance types to associate with the notebook instance. Currently, only one instance type can be associated with a notebook instance.
     */
    public val acceleratorTypes: List<String>? = builder.acceleratorTypes
    /**
     * An array of up to three Git repositories associated with the notebook instance. These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in [CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html) or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see [Associating Git repositories with SageMaker notebook instances](https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html) in the *Amazon SageMaker Developer Guide*.
     */
    public val additionalCodeRepositories: List<String>? = builder.additionalCodeRepositories
    /**
     * The Git repository associated with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in [CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html) or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see [Associating Git repositories with SageMaker notebook instances](https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html) in the *Amazon SageMaker Developer Guide*.
     */
    public val defaultCodeRepository: kotlin.String? = builder.defaultCodeRepository
    /**
     * Sets whether SageMaker provides internet access to the notebook instance. If you set this to `Disabled`, this notebook instance is able to access resources only in your VPC, and is not be able to connect to SageMaker training and endpoint services unless you configure a Network Address Translation (NAT) Gateway in your VPC.
     */
    public val directInternetAccess: kotlin.String? = builder.directInternetAccess
    /**
     * If status of the instance is `Failed`, the reason it failed.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * Information on the IMDS configuration of the notebook instance.
     */
    public val instanceMetadataServiceConfiguration: aws.sdk.kotlin.services.securityhub.model.AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails? = builder.instanceMetadataServiceConfiguration
    /**
     * The type of machine learning (ML) compute instance to launch for the notebook instance.
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * The Amazon Resource Name (ARN) of an Key Management Service (KMS) key that SageMaker uses to encrypt data on the storage volume attached to your notebook instance. The KMS key you provide must be enabled. For information, see [Enabling and disabling keys](https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html) in the *Key Management Service Developer Guide*.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The network interface ID that SageMaker created when the instance was created.
     */
    public val networkInterfaceId: kotlin.String? = builder.networkInterfaceId
    /**
     * The Amazon Resource Name (ARN) of the notebook instance.
     */
    public val notebookInstanceArn: kotlin.String? = builder.notebookInstanceArn
    /**
     * The name of a notebook instance lifecycle configuration.
     */
    public val notebookInstanceLifecycleConfigName: kotlin.String? = builder.notebookInstanceLifecycleConfigName
    /**
     * The name of the new notebook instance.
     */
    public val notebookInstanceName: kotlin.String? = builder.notebookInstanceName
    /**
     * The status of the notebook instance.
     */
    public val notebookInstanceStatus: kotlin.String? = builder.notebookInstanceStatus
    /**
     * The platform identifier of the notebook instance runtime environment.
     */
    public val platformIdentifier: kotlin.String? = builder.platformIdentifier
    /**
     * The Amazon Resource Name (ARN) of the IAM role associated with the instance.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Whether root access is enabled or disabled for users of the notebook instance.
     */
    public val rootAccess: kotlin.String? = builder.rootAccess
    /**
     * The VPC security group IDs.
     */
    public val securityGroups: List<String>? = builder.securityGroups
    /**
     * The ID of the VPC subnet to which you have a connectivity from your ML compute instance.
     */
    public val subnetId: kotlin.String? = builder.subnetId
    /**
     * The URL that you use to connect to the Jupyter notebook that is running in your notebook instance.
     */
    public val url: kotlin.String? = builder.url
    /**
     * The size, in GB, of the ML storage volume to attach to the notebook instance.
     */
    public val volumeSizeInGb: kotlin.Int? = builder.volumeSizeInGb

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsSageMakerNotebookInstanceDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsSageMakerNotebookInstanceDetails(")
        append("acceleratorTypes=$acceleratorTypes,")
        append("additionalCodeRepositories=$additionalCodeRepositories,")
        append("defaultCodeRepository=$defaultCodeRepository,")
        append("directInternetAccess=$directInternetAccess,")
        append("failureReason=$failureReason,")
        append("instanceMetadataServiceConfiguration=$instanceMetadataServiceConfiguration,")
        append("instanceType=$instanceType,")
        append("kmsKeyId=$kmsKeyId,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("notebookInstanceArn=$notebookInstanceArn,")
        append("notebookInstanceLifecycleConfigName=$notebookInstanceLifecycleConfigName,")
        append("notebookInstanceName=$notebookInstanceName,")
        append("notebookInstanceStatus=$notebookInstanceStatus,")
        append("platformIdentifier=$platformIdentifier,")
        append("roleArn=$roleArn,")
        append("rootAccess=$rootAccess,")
        append("securityGroups=$securityGroups,")
        append("subnetId=$subnetId,")
        append("url=$url,")
        append("volumeSizeInGb=$volumeSizeInGb")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceleratorTypes?.hashCode() ?: 0
        result = 31 * result + (additionalCodeRepositories?.hashCode() ?: 0)
        result = 31 * result + (defaultCodeRepository?.hashCode() ?: 0)
        result = 31 * result + (directInternetAccess?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (instanceMetadataServiceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (notebookInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (notebookInstanceLifecycleConfigName?.hashCode() ?: 0)
        result = 31 * result + (notebookInstanceName?.hashCode() ?: 0)
        result = 31 * result + (notebookInstanceStatus?.hashCode() ?: 0)
        result = 31 * result + (platformIdentifier?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (rootAccess?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (url?.hashCode() ?: 0)
        result = 31 * result + (volumeSizeInGb ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsSageMakerNotebookInstanceDetails

        if (acceleratorTypes != other.acceleratorTypes) return false
        if (additionalCodeRepositories != other.additionalCodeRepositories) return false
        if (defaultCodeRepository != other.defaultCodeRepository) return false
        if (directInternetAccess != other.directInternetAccess) return false
        if (failureReason != other.failureReason) return false
        if (instanceMetadataServiceConfiguration != other.instanceMetadataServiceConfiguration) return false
        if (instanceType != other.instanceType) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (notebookInstanceArn != other.notebookInstanceArn) return false
        if (notebookInstanceLifecycleConfigName != other.notebookInstanceLifecycleConfigName) return false
        if (notebookInstanceName != other.notebookInstanceName) return false
        if (notebookInstanceStatus != other.notebookInstanceStatus) return false
        if (platformIdentifier != other.platformIdentifier) return false
        if (roleArn != other.roleArn) return false
        if (rootAccess != other.rootAccess) return false
        if (securityGroups != other.securityGroups) return false
        if (subnetId != other.subnetId) return false
        if (url != other.url) return false
        if (volumeSizeInGb != other.volumeSizeInGb) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsSageMakerNotebookInstanceDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of Amazon Elastic Inference instance types to associate with the notebook instance. Currently, only one instance type can be associated with a notebook instance.
         */
        public var acceleratorTypes: List<String>? = null
        /**
         * An array of up to three Git repositories associated with the notebook instance. These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in [CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html) or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see [Associating Git repositories with SageMaker notebook instances](https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html) in the *Amazon SageMaker Developer Guide*.
         */
        public var additionalCodeRepositories: List<String>? = null
        /**
         * The Git repository associated with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in [CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html) or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see [Associating Git repositories with SageMaker notebook instances](https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html) in the *Amazon SageMaker Developer Guide*.
         */
        public var defaultCodeRepository: kotlin.String? = null
        /**
         * Sets whether SageMaker provides internet access to the notebook instance. If you set this to `Disabled`, this notebook instance is able to access resources only in your VPC, and is not be able to connect to SageMaker training and endpoint services unless you configure a Network Address Translation (NAT) Gateway in your VPC.
         */
        public var directInternetAccess: kotlin.String? = null
        /**
         * If status of the instance is `Failed`, the reason it failed.
         */
        public var failureReason: kotlin.String? = null
        /**
         * Information on the IMDS configuration of the notebook instance.
         */
        public var instanceMetadataServiceConfiguration: aws.sdk.kotlin.services.securityhub.model.AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails? = null
        /**
         * The type of machine learning (ML) compute instance to launch for the notebook instance.
         */
        public var instanceType: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of an Key Management Service (KMS) key that SageMaker uses to encrypt data on the storage volume attached to your notebook instance. The KMS key you provide must be enabled. For information, see [Enabling and disabling keys](https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html) in the *Key Management Service Developer Guide*.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The network interface ID that SageMaker created when the instance was created.
         */
        public var networkInterfaceId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the notebook instance.
         */
        public var notebookInstanceArn: kotlin.String? = null
        /**
         * The name of a notebook instance lifecycle configuration.
         */
        public var notebookInstanceLifecycleConfigName: kotlin.String? = null
        /**
         * The name of the new notebook instance.
         */
        public var notebookInstanceName: kotlin.String? = null
        /**
         * The status of the notebook instance.
         */
        public var notebookInstanceStatus: kotlin.String? = null
        /**
         * The platform identifier of the notebook instance runtime environment.
         */
        public var platformIdentifier: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role associated with the instance.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Whether root access is enabled or disabled for users of the notebook instance.
         */
        public var rootAccess: kotlin.String? = null
        /**
         * The VPC security group IDs.
         */
        public var securityGroups: List<String>? = null
        /**
         * The ID of the VPC subnet to which you have a connectivity from your ML compute instance.
         */
        public var subnetId: kotlin.String? = null
        /**
         * The URL that you use to connect to the Jupyter notebook that is running in your notebook instance.
         */
        public var url: kotlin.String? = null
        /**
         * The size, in GB, of the ML storage volume to attach to the notebook instance.
         */
        public var volumeSizeInGb: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsSageMakerNotebookInstanceDetails) : this() {
            this.acceleratorTypes = x.acceleratorTypes
            this.additionalCodeRepositories = x.additionalCodeRepositories
            this.defaultCodeRepository = x.defaultCodeRepository
            this.directInternetAccess = x.directInternetAccess
            this.failureReason = x.failureReason
            this.instanceMetadataServiceConfiguration = x.instanceMetadataServiceConfiguration
            this.instanceType = x.instanceType
            this.kmsKeyId = x.kmsKeyId
            this.networkInterfaceId = x.networkInterfaceId
            this.notebookInstanceArn = x.notebookInstanceArn
            this.notebookInstanceLifecycleConfigName = x.notebookInstanceLifecycleConfigName
            this.notebookInstanceName = x.notebookInstanceName
            this.notebookInstanceStatus = x.notebookInstanceStatus
            this.platformIdentifier = x.platformIdentifier
            this.roleArn = x.roleArn
            this.rootAccess = x.rootAccess
            this.securityGroups = x.securityGroups
            this.subnetId = x.subnetId
            this.url = x.url
            this.volumeSizeInGb = x.volumeSizeInGb
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsSageMakerNotebookInstanceDetails = AwsSageMakerNotebookInstanceDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails] inside the given [block]
         */
        public fun instanceMetadataServiceConfiguration(block: aws.sdk.kotlin.services.securityhub.model.AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails.Builder.() -> kotlin.Unit) {
            this.instanceMetadataServiceConfiguration = aws.sdk.kotlin.services.securityhub.model.AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
