// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * provides information about the Amazon S3 Public Access Block configuration for accounts.
 */
public class AwsS3AccountPublicAccessBlockDetails private constructor(builder: Builder) {
    /**
     * Indicates whether to reject calls to update an S3 bucket if the calls include a public access control list (ACL).
     */
    public val blockPublicAcls: kotlin.Boolean? = builder.blockPublicAcls
    /**
     * Indicates whether to reject calls to update the access policy for an S3 bucket or access point if the policy allows public access.
     */
    public val blockPublicPolicy: kotlin.Boolean? = builder.blockPublicPolicy
    /**
     * Indicates whether Amazon S3 ignores public ACLs that are associated with an S3 bucket.
     */
    public val ignorePublicAcls: kotlin.Boolean? = builder.ignorePublicAcls
    /**
     * Indicates whether to restrict access to an access point or S3 bucket that has a public policy to only Amazon Web Services service principals and authorized users within the S3 bucket owner's account.
     */
    public val restrictPublicBuckets: kotlin.Boolean? = builder.restrictPublicBuckets

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsS3AccountPublicAccessBlockDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsS3AccountPublicAccessBlockDetails(")
        append("blockPublicAcls=$blockPublicAcls,")
        append("blockPublicPolicy=$blockPublicPolicy,")
        append("ignorePublicAcls=$ignorePublicAcls,")
        append("restrictPublicBuckets=$restrictPublicBuckets")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = blockPublicAcls?.hashCode() ?: 0
        result = 31 * result + (blockPublicPolicy?.hashCode() ?: 0)
        result = 31 * result + (ignorePublicAcls?.hashCode() ?: 0)
        result = 31 * result + (restrictPublicBuckets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsS3AccountPublicAccessBlockDetails

        if (blockPublicAcls != other.blockPublicAcls) return false
        if (blockPublicPolicy != other.blockPublicPolicy) return false
        if (ignorePublicAcls != other.ignorePublicAcls) return false
        if (restrictPublicBuckets != other.restrictPublicBuckets) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsS3AccountPublicAccessBlockDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether to reject calls to update an S3 bucket if the calls include a public access control list (ACL).
         */
        public var blockPublicAcls: kotlin.Boolean? = null
        /**
         * Indicates whether to reject calls to update the access policy for an S3 bucket or access point if the policy allows public access.
         */
        public var blockPublicPolicy: kotlin.Boolean? = null
        /**
         * Indicates whether Amazon S3 ignores public ACLs that are associated with an S3 bucket.
         */
        public var ignorePublicAcls: kotlin.Boolean? = null
        /**
         * Indicates whether to restrict access to an access point or S3 bucket that has a public policy to only Amazon Web Services service principals and authorized users within the S3 bucket owner's account.
         */
        public var restrictPublicBuckets: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsS3AccountPublicAccessBlockDetails) : this() {
            this.blockPublicAcls = x.blockPublicAcls
            this.blockPublicPolicy = x.blockPublicPolicy
            this.ignorePublicAcls = x.ignorePublicAcls
            this.restrictPublicBuckets = x.restrictPublicBuckets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsS3AccountPublicAccessBlockDetails = AwsS3AccountPublicAccessBlockDetails(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
